/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Dictionary;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.elaf.EWTLookAndFeel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextComponent;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;

public class LWComponent
extends PaintContextComponent {
    private int _alignment = 0;
    private int _repaintFrozenLevel;
    private Rectangle _frozenDamage;
    private Rectangle _frozenSyncDamage;
    private PaintContext _borderContext;
    private Painter _fill;
    private static final String _KEY_INSTALLED = "oracle.bali.ewt.LWComponent.INSTALLED";
    private static boolean _IS_LINUX;

    public LWComponent() {
        LWComponent._tryInstallation();
    }

    public void setFill(Painter fill) {
        this._fill = fill;
        this.repaint();
    }

    public Painter getFill() {
        return this._fill;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(int alignment) {
        this._alignment = alignment;
    }

    public int getActualAlignment() {
        int alignment = this.getAlignment();
        if (alignment == 0) {
            return LocaleUtils.getAlignmentForReadingDirection(this.getActualReadingDirection());
        }
        return alignment;
    }

    public int getActualReadingDirection() {
        return this.getPaintContext().getReadingDirection();
    }

    public void freezeRepaints() {
        ++this._repaintFrozenLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfreezeRepaints() {
        --this._repaintFrozenLevel;
        if (this._repaintFrozenLevel == 0) {
            Rectangle frozenSyncDamage;
            Rectangle frozenDamage;
            LWComponent lWComponent = this;
            synchronized (lWComponent) {
                frozenDamage = this._frozenDamage;
                this._frozenDamage = null;
                frozenSyncDamage = this._frozenSyncDamage;
                this._frozenSyncDamage = null;
            }
            if (frozenSyncDamage != null) {
                if (frozenDamage != null && frozenSyncDamage.intersects(frozenDamage)) {
                    frozenSyncDamage.add(frozenDamage);
                    this.computeVisibleRect(frozenDamage);
                    LWComponent._intersectRect(frozenSyncDamage, frozenDamage, frozenSyncDamage);
                    frozenDamage = null;
                }
                this.paintImmediately(frozenSyncDamage.x, frozenSyncDamage.y, frozenSyncDamage.width, frozenSyncDamage.height);
            }
            if (frozenDamage != null) {
                this.repaint(frozenDamage.x, frozenDamage.y, frozenDamage.width, frozenDamage.height);
            }
        }
    }

    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        this.print(g);
    }

    public Dimension getDocumentSize(PaintContext context, Dictionary printProperties) {
        return this.getSize();
    }

    public Rectangle getPageBounds(PaintContext context, Dictionary printProperties, int pageXOrigin, int pageYOrigin, int pageWidth, int pageHeight) {
        return new Rectangle(pageWidth, pageHeight, pageWidth, pageHeight);
    }

    public final void repaintInterior() {
        ImmInsets insets = this.getBorderInsets();
        this.repaint(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
    }

    public final void repaintInterior(int x, int y, int width, int height) {
        ImmInsets innerOrigin = this.getBorderInsets();
        this.repaint(x + innerOrigin.left, y + innerOrigin.top, width, height);
    }

    public final void paintImmediateInterior() {
        ImmInsets insets = this.getBorderInsets();
        this.paintImmediately(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
    }

    public final void paintImmediateInterior(int x, int y, int width, int height) {
        ImmInsets innerOrigin = this.getBorderInsets();
        this.paintImmediately(x + innerOrigin.left, y + innerOrigin.top, width, height);
    }

    public final ImmInsets getBorderInsets() {
        return UIUtils.getInsets(this);
    }

    public PaintContext getPrintPaintContext(Graphics printGraphics) {
        if (printGraphics == null) {
            throw new IllegalArgumentException();
        }
        return new PrintContext(printGraphics);
    }

    public final void clipToParents(Rectangle visibleRect) {
        this.computeVisibleRect(visibleRect);
    }

    public void paintImmediately(int x, int y, int w, int h) {
        if (!this._addFrozenDamage(x, y, w, h, true)) {
            super.paintImmediately(x, y, w, h);
        }
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        if (!this._addFrozenDamage(x, y, width, height, false)) {
            super.repaint(tm, x, y, width, height);
        }
    }

    public void updateUI() {
        this.setUI(null);
    }

    public void addNotify() {
        if (_IS_LINUX) {
            LWComponent._tryInstallation();
        }
        super.addNotify();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void paintComponent(Graphics g) {
        if (this.ui != null) {
            super.paintComponent(g);
        } else if (this.isOpaque()) {
            UIUtils.fillBackground(g, this);
        }
        Painter fill = this.getFill();
        if (fill != null) {
            fill.paint(this.getPaintContext(), g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.paintOverChildren(g);
    }

    protected void paintOverChildren(Graphics g) {
    }

    protected final void processEvent(AWTEvent e) {
        this.processEventImpl(e);
    }

    protected void processEventImpl(AWTEvent e) {
        super.processEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _addFrozenDamage(int x, int y, int width, int height, boolean synchronous) {
        boolean wasFrozen;
        if (this._repaintFrozenLevel == 0) {
            Container parent = this.getParent();
            if (parent instanceof LWComponent) {
                LWComponent lwc = (LWComponent)parent;
                wasFrozen = lwc._addFrozenDamage(x + this.getX(), y + this.getY(), width, height, synchronous);
            } else {
                wasFrozen = false;
            }
        } else {
            Rectangle repaintRect = new Rectangle(x, y, width, height);
            LWComponent lWComponent = this;
            synchronized (lWComponent) {
                boolean bl = wasFrozen = this._repaintFrozenLevel != 0;
                if (wasFrozen) {
                    Rectangle damage;
                    Rectangle rectangle = damage = synchronous ? this._frozenSyncDamage : this._frozenDamage;
                    if (damage == null) {
                        damage = repaintRect;
                    } else {
                        damage.add(repaintRect);
                    }
                    if (synchronous) {
                        this._frozenSyncDamage = damage;
                    } else {
                        this._frozenDamage = damage;
                    }
                }
            }
        }
        return wasFrozen;
    }

    private static void _tryInstallation() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        if (Boolean.TRUE.equals(defaults.get(_KEY_INSTALLED))) {
            return;
        }
        try {
            EWTLookAndFeel.installEWTLookAndFeel();
            defaults.put(_KEY_INSTALLED, Boolean.TRUE);
        }
        catch (Exception e) {
            System.err.println("Could not install EWT look-and-feel:");
            e.printStackTrace();
        }
    }

    private static void _intersectRect(Rectangle destRect, Rectangle rect1, Rectangle rect2) {
        int rect1Left = rect1.x;
        int rect1Right = rect1Left + rect1.width;
        int rect1Top = rect1.y;
        int rect1Bottom = rect1Top + rect1.height;
        int rect2Left = rect2.x;
        int rect2Right = rect2Left + rect2.width;
        int rect2Top = rect2.y;
        int rect2Bottom = rect2Top + rect2.height;
        destRect.x = rect1Left >= rect2Left ? rect1Left : rect2Left;
        destRect.y = rect1Top >= rect2Top ? rect1Top : rect2Top;
        destRect.width = (rect1Right <= rect2Right ? rect1Right : rect2Right) - destRect.x;
        destRect.height = (rect1Bottom <= rect2Bottom ? rect1Bottom : rect2Bottom) - destRect.y;
    }

    static {
        String os = System.getProperty("os.name");
        _IS_LINUX = os != null && os.indexOf("Linux") != -1;
    }

    private class PrintContext
    extends PaintContextProxy {
        private Graphics _printGraphics;

        public PrintContext(Graphics printGraphics) {
            this._printGraphics = printGraphics;
        }

        protected PaintContext getPaintContext() {
            return LWComponent.this.getPaintContext();
        }

        public int getPaintState() {
            return 0;
        }

        public FontMetrics getFontMetrics(Font font) {
            return this._printGraphics.getFontMetrics(font);
        }
    }
}

