/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.taglib.rt;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import oracle.i18n.util.GDKMessage;

public class TagUtility {
    static final int INVALID_SCOPE = -1;

    private TagUtility() {
    }

    static int getScope(String string) {
        if (string.toLowerCase(Locale.US).equals("application")) {
            return 4;
        }
        if (string.toLowerCase(Locale.US).equals("session")) {
            return 3;
        }
        if (string.toLowerCase(Locale.US).equals("request")) {
            return 2;
        }
        if (string.toLowerCase(Locale.US).equals("page")) {
            return 1;
        }
        throw new IllegalArgumentException(GDKMessage.getMessage(5218));
    }

    static int getDateFormatStyle(String string) {
        if (string.toLowerCase(Locale.US).equals("long")) {
            return 1;
        }
        if (string.toLowerCase(Locale.US).equals("short") || string.toLowerCase(Locale.US).equals("default")) {
            return 3;
        }
        throw new IllegalArgumentException(GDKMessage.getMessage(5219));
    }

    static void output(String string, int n, PageContext pageContext, Object object) throws JspException {
        TagUtility.output(string, n, pageContext, pageContext.getOut(), object);
    }

    static void output(String string, int n, PageContext pageContext, JspWriter jspWriter, Object object) throws JspException {
        if (string == null) {
            try {
                jspWriter.print(object);
            }
            catch (IOException iOException) {
                throw new JspException(iOException.getMessage());
            }
        } else {
            switch (n) {
                case 2: {
                    pageContext.getRequest().setAttribute(string, object);
                    break;
                }
                case 3: {
                    pageContext.getSession().setAttribute(string, object);
                    break;
                }
                case 4: {
                    pageContext.getServletContext().setAttribute(string, object);
                    break;
                }
                default: {
                    pageContext.setAttribute(string, object);
                }
            }
        }
    }

    static void removeValue(String string, int n, PageContext pageContext) {
        switch (n) {
            case 1: {
                pageContext.removeAttribute(string);
                break;
            }
            case 2: {
                pageContext.getRequest().removeAttribute(string);
                break;
            }
            case 3: {
                pageContext.getSession().removeAttribute(string);
                break;
            }
            case 4: {
                pageContext.getServletContext().removeAttribute(string);
            }
        }
    }
}

