/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import oracle.dbtools.util.encoding.Decoder;
import oracle.dbtools.util.encoding.Encoder;
import oracle.dbtools.util.encoding.Encoding;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.MimeType;

public class HEXEncoding
extends Encoding
implements Decoder,
Encoder {
    private static final char[] map0;
    private static final char[] map1;
    private static byte[] map2;

    public HEXEncoding(MimeType mimeType) {
        super(EncodingType.ENCODING_HEX, mimeType);
    }

    public char[] encodeToCharArray(byte[] byArray) throws EncodingException, IOException {
        return this.encodeToCharArray(byArray, -1, null);
    }

    public char[] encodeToCharArray(byte[] byArray, int n, String string) throws EncodingException, IOException {
        return this.encodeToString(byArray, n, string).toCharArray();
    }

    public String encodeToString(byte[] byArray) throws EncodingException, IOException {
        return this.encodeToString(byArray, -1, null);
    }

    public String encodeToString(byte[] byArray, int n, String string) throws EncodingException, IOException {
        StringWriter stringWriter = new StringWriter();
        this.encode(new ByteArrayInputStream(byArray), stringWriter, n, string);
        return stringWriter.toString();
    }

    @Override
    public long getEncodeLength(long l) {
        return this.getEncodeLength(l, -1, null);
    }

    public long getEncodeLength(byte[] byArray, int n, String string) {
        return this.getEncodeLength(byArray.length, n, string);
    }

    public long getEncodeLength(long l, int n, String string) {
        long l2 = l;
        long l3 = l2 * 2L;
        long l4 = 0L;
        if (n > 0 && string != null) {
            int n2 = string.length();
            l4 = l3 / (long)n * (long)n2;
            if (l3 % (long)n == 0L) {
                l4 -= (long)n2;
            }
        }
        return l3 + l4;
    }

    public void encode(InputStream inputStream, Writer writer) throws EncodingException, IOException {
        this.encode(inputStream, writer, -1, null);
    }

    public void encode(InputStream inputStream, Writer writer, int n, String string) throws EncodingException, IOException {
        long l = 0L;
        long l2 = 0L;
        int n2 = inputStream.read();
        while (n2 != -1) {
            ++l;
            int n3 = n2 & 0xFF;
            int n4 = n3 >> 4;
            int n5 = n3 & 0xF;
            HEXEncoding.writeChar(writer, map0[n4], l2++, n, string);
            HEXEncoding.writeChar(writer, map0[n5], l2++, n, string);
            n2 = inputStream.read();
        }
        writer.flush();
    }

    private static void writeChar(Writer writer, int n, long l, int n2, String string) throws IOException {
        if (n2 > 0 && l > 0L && string != null && l % (long)n2 == 0L) {
            writer.write(string);
        }
        writer.write(n);
    }

    public byte[] decodeToByteArray(char[] cArray) throws EncodingException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decode(new CharArrayReader(cArray), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] decodeToByteArray(String string) throws EncodingException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decode(new StringReader(string), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public long getDecodeLength(String string) throws EncodingException {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            ++l;
        }
        return this.getDecodeLength(l);
    }

    public long getDecodeLength(char[] cArray) throws EncodingException {
        long l = 0L;
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            ++l;
        }
        return this.getDecodeLength(l);
    }

    @Override
    public long getDecodeLength(long l) throws EncodingException {
        if (l % 2L != 0L) {
            throw new EncodingException("Length of Hex encoded input string is not a multiple of 2.");
        }
        return l / 2L;
    }

    @Override
    public int getDecodeBlocksize() {
        return 2;
    }

    @Override
    public int getEncodeBlocksize() {
        return 1;
    }

    public void decode(Reader reader, OutputStream outputStream) throws EncodingException, IOException {
        int n = HEXEncoding.readChar(reader);
        while (n != -1) {
            int n2 = HEXEncoding.readChar(reader);
            if (n2 == -1) {
                throw new EncodingException("Length of Hex encoded input is not a multiple of 2.");
            }
            if (n > 127 || n2 > 127) {
                throw new EncodingException("Illegal character in Hex encoded input.");
            }
            byte by = map2[n];
            byte by2 = map2[n2];
            if (by < 0 || by2 < 0) {
                throw new EncodingException("Illegal character in Hex encoded input.");
            }
            int n3 = by << 4 | by2 & 0xF;
            outputStream.write(n3);
            n = HEXEncoding.readChar(reader);
        }
        outputStream.flush();
    }

    private static int readChar(Reader reader) throws IOException {
        int n = reader.read();
        while (n != -1 && Character.isWhitespace((char)n)) {
            n = reader.read();
        }
        return n;
    }

    public Object decodeBuffer(Object object) throws EncodingException, IOException {
        if (object == null) {
            return null;
        }
        return this.decodeToByteArray((String)object);
    }

    @Override
    public void decodeStream(Object object, Object object2) throws EncodingException, IOException {
        this.decode((Reader)object, (OutputStream)object2);
    }

    public Object encodeBuffer(Object object) throws EncodingException, IOException {
        if (object == null) {
            return null;
        }
        return this.encodeToString((byte[])object);
    }

    @Override
    public void encodeStream(Object object, Object object2) throws EncodingException, IOException {
        this.encode((InputStream)object, (Writer)object2);
    }

    static {
        int n;
        map0 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        map1 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        map2 = new byte[128];
        for (n = 0; n < map2.length; ++n) {
            HEXEncoding.map2[n] = -1;
        }
        for (n = 0; n < map0.length; ++n) {
            HEXEncoding.map2[HEXEncoding.map0[n]] = (byte)n;
        }
        for (n = 0; n < map1.length; ++n) {
            HEXEncoding.map2[HEXEncoding.map1[n]] = (byte)n;
        }
    }
}

