/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.dbtools.util.Messages;

public class Logger {
    private static final String NO_THROWABLE_STACK_ELEMENT = "(Internal error) No Throwable Stack Element";
    private static final String NO_THROWABLE_OBJECT_FOUND = "(Internal error) No Throwable object found";
    private static final String NO_THROWABLE_OBJECT_THREAD_DIED = "(Internal error) Thread died because there is no throwable object";

    private Logger() {
    }

    public static void ignore(Class<?> clazz, Throwable throwable) {
        String string = Messages.format("Logger_ignored", Logger.format(throwable));
        Logger.log(clazz, Level.FINE, string, throwable);
    }

    public static void finest(Class<?> clazz, Throwable throwable) {
        Logger.log(clazz, Level.FINEST, Logger.format(throwable), throwable);
    }

    public static void finer(Class<?> clazz, Throwable throwable) {
        Logger.log(clazz, Level.FINER, Logger.format(throwable), throwable);
    }

    public static void fine(Class<?> clazz, Throwable throwable) {
        Logger.log(clazz, Level.FINE, Logger.format(throwable), throwable);
    }

    public static void info(Class<?> clazz, Throwable throwable) {
        Logger.log(clazz, Level.INFO, Logger.format(throwable), throwable);
    }

    public static void warn(Class<?> clazz, Throwable throwable) {
        Logger.log(clazz, Level.WARNING, Logger.format(throwable), throwable);
    }

    public static void severe(Class<?> clazz, Throwable throwable) {
        Logger.log(clazz, Level.SEVERE, Logger.format(throwable), throwable);
    }

    public static void finest(Class<?> clazz, String string) {
        Logger.log(clazz, Level.FINEST, string, null);
    }

    public static void finer(Class<?> clazz, String string) {
        Logger.log(clazz, Level.FINER, string, null);
    }

    public static void fine(Class<?> clazz, String string) {
        Logger.log(clazz, Level.FINE, string, null);
    }

    public static void info(Class<?> clazz, String string) {
        Logger.log(clazz, Level.INFO, string, null);
    }

    public static void warn(Class<?> clazz, String string) {
        Logger.log(clazz, Level.WARNING, string, null);
    }

    public static void severe(Class<?> clazz, String string) {
        Logger.log(clazz, Level.SEVERE, string, null);
    }

    public static void finest(Class<?> clazz, String string, Throwable throwable) {
        Logger.log(clazz, Level.FINEST, Logger.format(string, throwable), throwable);
    }

    public static void finer(Class<?> clazz, String string, Throwable throwable) {
        Logger.log(clazz, Level.FINER, Logger.format(string, throwable), throwable);
    }

    public static void fine(Class<?> clazz, String string, Throwable throwable) {
        Logger.log(clazz, Level.FINE, Logger.format(string, throwable), throwable);
    }

    public static void info(Class<?> clazz, String string, Throwable throwable) {
        Logger.log(clazz, Level.INFO, Logger.format(string, throwable), throwable);
    }

    public static void warn(Class<?> clazz, String string, Throwable throwable) {
        Logger.log(clazz, Level.WARNING, Logger.format(string, throwable), throwable);
    }

    public static void severe(Class<?> clazz, String string, Throwable throwable) {
        Logger.log(clazz, Level.SEVERE, Logger.format(string, throwable), throwable);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        Logger.log(clazz, Level.INFO, stringWriter.toString(), throwable);
    }

    private static String format(Throwable throwable) {
        if (throwable == null) {
            return Messages.format("Logger_exception", NO_THROWABLE_OBJECT_FOUND, NO_THROWABLE_OBJECT_THREAD_DIED);
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray.length == 0) {
            return Messages.format("Logger_exception", throwable.getLocalizedMessage(), NO_THROWABLE_STACK_ELEMENT);
        }
        return Messages.format("Logger_exception", throwable.getLocalizedMessage(), throwable.getStackTrace()[0].toString());
    }

    private static String format(String string, Throwable throwable) {
        return Messages.format("Logger_detail", string, Logger.format(throwable));
    }

    public static void log(Class<?> clazz, Level level, String string, Throwable throwable) {
        if (null == clazz) {
            clazz = Logger.class;
        }
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setThrown(throwable);
        Logger.inferCaller(logRecord);
        java.util.logging.Logger.getLogger(clazz.getName()).log(logRecord);
    }

    private static void inferCaller(LogRecord logRecord) {
        StackTraceElement stackTraceElement;
        String string;
        int n;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        for (n = 0; n < stackTraceElementArray.length && !(string = (stackTraceElement = stackTraceElementArray[n]).getClassName()).equals(Logger.class.getName()); ++n) {
        }
        while (n < stackTraceElementArray.length) {
            stackTraceElement = stackTraceElementArray[n];
            string = stackTraceElement.getClassName();
            if (!string.equals(Logger.class.getName())) {
                logRecord.setSourceClassName(string);
                logRecord.setSourceMethodName(stackTraceElement.getMethodName());
                return;
            }
            ++n;
        }
    }
}

