/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.xml.bind.DatatypeConverter;

public class Encryption {
    public static byte[] generateSalt(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Null or empty seed values");
        }
        assert (stringArray != null);
        byte[] byArray = new byte[]{-116, 77, 101, -88, -97, 80, 82, 51};
        int n = byArray.length;
        for (String string : stringArray) {
            if (string != null) {
                int n2 = 0;
                for (byte by : string.getBytes()) {
                    byArray[n2 % n] = (byte)(by ^ byArray[n2 % n]);
                    ++n2;
                }
                continue;
            }
            throw new IllegalArgumentException("Null seed value");
        }
        return byArray;
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String encrypt(char[] cArray, String string, byte[] byArray) {
        if (cArray == null || cArray.length == 0 || Encryption.isNullOrEmpty(string) || byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            Wrapper wrapper = Wrapper.newInstance(string, byArray);
            return wrapper.encrypt(cArray);
        }
        catch (Throwable throwable) {
            throw Encryption.asRuntimeException(throwable);
        }
    }

    public static char[] decrypt(String string, String string2, byte[] byArray) {
        if (Encryption.isNullOrEmpty(string) || Encryption.isNullOrEmpty(string2) || byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            Wrapper wrapper = Wrapper.newInstance(string2, byArray);
            return wrapper.decrypt(string);
        }
        catch (Throwable throwable) {
            throw Encryption.asRuntimeException(throwable);
        }
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private static RuntimeException asRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    static final class Wrapper {
        private static final int ITERATION_COUNT = 42;
        private Cipher m_encoder;
        private Cipher m_decoder;
        private AlgorithmParameterSpec m_paramSpec;
        private SecretKey m_key;
        private CharsetEncoder m_charEnc;
        private CharsetDecoder m_charDec;

        public static Wrapper newInstance(String string, byte[] byArray) throws InvalidKeySpecException, NoSuchAlgorithmException {
            if (null == string || null == byArray) {
                throw new IllegalArgumentException("null arguments");
            }
            return new Wrapper(string, byArray);
        }

        private Wrapper(String string, byte[] byArray) throws InvalidKeySpecException, NoSuchAlgorithmException {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), byArray, 42);
            this.m_key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(pBEKeySpec);
            this.m_paramSpec = new PBEParameterSpec(byArray, 42);
        }

        public String encrypt(char[] cArray) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, CharacterCodingException, IllegalBlockSizeException, BadPaddingException {
            if (null == cArray || cArray.length == 0) {
                throw new IllegalArgumentException("null input value");
            }
            byte[] byArray = null;
            if (this.m_encoder == null) {
                this.m_encoder = Cipher.getInstance(this.m_key.getAlgorithm());
                this.m_encoder.init(1, (Key)this.m_key, this.m_paramSpec);
            }
            if (this.m_charEnc == null) {
                this.m_charEnc = StandardCharsets.UTF_8.newEncoder();
            }
            ByteBuffer byteBuffer = this.m_charEnc.encode(CharBuffer.wrap(cArray));
            byte[] byArray2 = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray2);
            byArray = this.m_encoder.doFinal(byArray2);
            return DatatypeConverter.printBase64Binary((byte[])byArray);
        }

        public char[] decrypt(String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, CharacterCodingException {
            if (Encryption.isNullOrEmpty(string)) {
                throw new IllegalArgumentException("null input string");
            }
            if (this.m_decoder == null) {
                this.m_decoder = Cipher.getInstance(this.m_key.getAlgorithm());
                this.m_decoder.init(2, (Key)this.m_key, this.m_paramSpec);
            }
            byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
            byte[] byArray2 = this.m_decoder.doFinal(byArray);
            if (this.m_charDec == null) {
                this.m_charDec = StandardCharsets.UTF_8.newDecoder();
            }
            CharBuffer charBuffer = this.m_charDec.decode(ByteBuffer.wrap(byArray2));
            char[] cArray = new char[charBuffer.limit()];
            charBuffer.get(cArray);
            return cArray;
        }
    }
}

