/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

public class Array {
    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2 = 1000000;
        int[] nArray = new int[n2 / 2];
        int[] nArray2 = new int[n2 / 2];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 2 * n;
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray[n] = 2 * n + 1;
        }
        long l = System.nanoTime();
        Array.merge(nArray, nArray2);
        System.out.println(System.nanoTime() - l);
    }

    public static int indexOf(int[] nArray, int n) {
        return Array.indexOf(nArray, 0, nArray.length - 1, n);
    }

    public static int indexOf(long[] lArray, long l) {
        return Array.indexOf(lArray, 0, lArray.length - 1, l);
    }

    private static int indexOf(int[] nArray, int n, int n2, int n3) {
        if (n + 1 == n2 || n == n2) {
            return nArray[n] < n3 ? n2 : n;
        }
        int n4 = (n + n2) / 2;
        if (n3 < nArray[n4]) {
            return Array.indexOf(nArray, n, n4, n3);
        }
        return Array.indexOf(nArray, n4, n2, n3);
    }

    private static int indexOf(long[] lArray, int n, int n2, long l) {
        if (n + 1 == n2 || n == n2) {
            return lArray[n] < l ? n2 : n;
        }
        int n3 = (n + n2) / 2;
        if (l < lArray[n3]) {
            return Array.indexOf(lArray, n, n3, l);
        }
        return Array.indexOf(lArray, n3, n2, l);
    }

    public static int[] insert(int[] nArray, int n) {
        int n2;
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{n};
            return nArray;
        }
        int n3 = Array.indexOf(nArray, 0, nArray.length, n);
        if (n3 < nArray.length && nArray[n3] == n) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length + 1];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = nArray[n2];
        }
        nArray2[n3] = n;
        for (n2 = n3 + 1; n2 < nArray2.length; ++n2) {
            nArray2[n2] = nArray[n2 - 1];
        }
        return nArray2;
    }

    public static long[] insert(long[] lArray, long l) {
        int n;
        if (lArray == null || lArray.length == 0) {
            lArray = new long[]{l};
            return lArray;
        }
        int n2 = Array.indexOf(lArray, 0, lArray.length, l);
        if (n2 < lArray.length && lArray[n2] == l) {
            return lArray;
        }
        long[] lArray2 = new long[lArray.length + 1];
        for (n = 0; n < n2; ++n) {
            lArray2[n] = lArray[n];
        }
        lArray2[n2] = l;
        for (n = n2 + 1; n < lArray2.length; ++n) {
            lArray2[n] = lArray[n - 1];
        }
        return lArray2;
    }

    public static int[] delete(int[] nArray, int n) {
        int n2;
        int n3 = Array.indexOf(nArray, 0, nArray.length, n);
        if (n3 == nArray.length || nArray[n3] != n) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length - 1];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = nArray[n2];
        }
        for (n2 = n3; n2 < nArray2.length; ++n2) {
            nArray2[n2] = nArray[n2 + 1];
        }
        return nArray2;
    }

    public static int[] merge(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            return nArray2;
        }
        if (nArray2 == null) {
            return nArray;
        }
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int[] nArray3 = new int[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n2 && n5 < n3) {
            if (nArray[n4] == nArray2[n5]) {
                nArray3[n6++] = nArray[n4++];
                ++n5;
                continue;
            }
            if (nArray[n4] < nArray2[n5]) {
                nArray3[n6++] = nArray[n4++];
                continue;
            }
            nArray3[n6++] = nArray2[n5++];
        }
        if (n4 < n2) {
            for (n = n4; n < n2; ++n) {
                nArray3[n6++] = nArray[n];
            }
        } else {
            for (n = n5; n < n3; ++n) {
                nArray3[n6++] = nArray2[n];
            }
        }
        int[] nArray4 = new int[n6];
        for (int i = 0; i < n6; ++i) {
            nArray4[i] = nArray3[i];
        }
        return nArray4;
    }

    public static long[] merge(long[] lArray, long[] lArray2) {
        int n;
        if (lArray == null) {
            return lArray2;
        }
        if (lArray2 == null) {
            return lArray;
        }
        int n2 = lArray.length;
        int n3 = lArray2.length;
        long[] lArray3 = new long[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n2 && n5 < n3) {
            if (lArray[n4] == lArray2[n5]) {
                lArray3[n6++] = lArray[n4++];
                ++n5;
                continue;
            }
            if (lArray[n4] < lArray2[n5]) {
                lArray3[n6++] = lArray[n4++];
                continue;
            }
            lArray3[n6++] = lArray2[n5++];
        }
        if (n4 < n2) {
            for (n = n4; n < n2; ++n) {
                lArray3[n6++] = lArray[n];
            }
        } else {
            for (n = n5; n < n3; ++n) {
                lArray3[n6++] = lArray2[n];
            }
        }
        long[] lArray4 = new long[n6];
        for (int i = 0; i < n6; ++i) {
            lArray4[i] = lArray3[i];
        }
        return lArray4;
    }

    public static boolean next(int[] nArray, int[] nArray2) {
        return Array.next(nArray, nArray2, 0);
    }

    public static boolean next(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < nArray2[i] - 1) {
                int n2 = i;
                nArray[n2] = nArray[n2] + 1;
                return true;
            }
            nArray[i] = n;
        }
        return false;
    }
}

