/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.transfer.file.FileChunk;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.util.Logger;

public class DataFileScriptGenerator {
    private static final Class<?> clazz = DataFileScriptGenerator.class;
    private static final String SQUOTE = "'";
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private static final String SPACE = " ";
    private static final String EOL = "\n";
    private static final String SOURCE_FILES = "<SourceFiles>";
    private static final String SOURCE_CHUNK_FILES = "<SourceChunkFiles>";
    private static final String TARGET_DIR = "<TargetDir>";
    private static final String LOG_FILE = "<LogFile>";
    private static DecimalFormat df = new DecimalFormat("#0.0000");
    private static final String PASS_TOKEN = "PASSED";
    private static final String CHECK_CHUNK_TOKEN = "CHECK_CHUNK";
    public static final int RESTART_REQUEST = 2;
    public static final int CHECK_CHUNK_REQUEST = 5;

    public static String generatePreTransferScript(List<FileInfo> list, String string, String string2) {
        String string3 = DataFileScriptGenerator.generateScript(list, string, string2);
        string3 = string3 + "preTransfer\n";
        return string3;
    }

    public static String generatePostTransferScript(List<FileInfo> list, String string, String string2) {
        String string3 = DataFileScriptGenerator.generateScript(list, string, string2);
        string3 = string3 + "postTransfer\n";
        return string3;
    }

    public static String generateSignatureCheckScript(List<FileInfo> list, String string, String string2) {
        String string3 = DataFileScriptGenerator.generateScript(list, string, string2, false, false);
        string3 = string3 + "signatureCheck\n";
        return string3;
    }

    private static String generateScript(List<FileInfo> list, String string, String string2) {
        return DataFileScriptGenerator.generateScript(list, string, string2, true, false);
    }

    private static String generateScript(List<FileInfo> list, String string, String string2, boolean bl, boolean bl2) {
        String string3 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(DataFileScriptGenerator.class.getResourceAsStream("ShellScript.txt")));
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                string3 = string4.contains(SOURCE_FILES) ? string3 + string4.replace(SOURCE_FILES, DataFileScriptGenerator.getSourceFileData(list)) : (string4.contains(SOURCE_CHUNK_FILES) ? (bl ? string3 + string4.replace(SOURCE_CHUNK_FILES, DataFileScriptGenerator.getChunkFileData(list, bl2)) : string3 + string4.replace(SOURCE_CHUNK_FILES, "('dummy dummy')\n")) : (string4.contains(TARGET_DIR) ? string3 + string4.replace(TARGET_DIR, string) : (string4.contains(LOG_FILE) ? string3 + string4.replace(LOG_FILE, string2) : string3 + string4)));
                string3 = string3 + EOL;
                string4 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            Logger.severe(clazz, "Unable to open script template file.", exception);
        }
        return string3;
    }

    private static CharSequence getSourceFileData(List<FileInfo> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(LPAREN).append(EOL);
        for (FileInfo fileInfo : list) {
            stringBuilder.append(SQUOTE);
            stringBuilder.append(fileInfo.getPath().getFileName().toString());
            stringBuilder.append(SPACE).append(fileInfo.getMd5());
            stringBuilder.append(SPACE).append(fileInfo.getFileChunks().size());
            stringBuilder.append(SPACE).append(fileInfo.getTargetDir());
            stringBuilder.append(SPACE).append(String.valueOf(!fileInfo.isTransferred()));
            stringBuilder.append(SPACE).append(fileInfo.getLength());
            stringBuilder.append(SQUOTE).append(EOL);
        }
        stringBuilder.append(RPAREN).append(EOL);
        return stringBuilder.toString();
    }

    private static CharSequence getChunkFileData(List<FileInfo> list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(LPAREN).append(EOL);
        long l = System.nanoTime();
        for (FileInfo fileInfo : list) {
            for (FileChunk fileChunk : fileInfo.getFileChunks()) {
                if (bl) {
                    if (!fileChunk.isChunkCheckRequested()) continue;
                    fileChunk.calculateMd5();
                    stringBuilder.append(SQUOTE);
                    stringBuilder.append(fileChunk.getName());
                    stringBuilder.append(SPACE).append(fileChunk.getMd5());
                    stringBuilder.append(SQUOTE).append(EOL);
                    continue;
                }
                stringBuilder.append(SQUOTE);
                stringBuilder.append(fileChunk.getName());
                stringBuilder.append(SPACE).append(fileChunk.getMd5());
                stringBuilder.append(SQUOTE).append(EOL);
            }
        }
        double d = (double)(System.nanoTime() - l) / 1.0E9;
        Logger.info(DataFileScriptGenerator.class, df.format(d) + " seconds");
        stringBuilder.append(RPAREN).append(EOL);
        return stringBuilder.toString();
    }

    public static void evaluate(List<FileInfo> list, ScriptOutput scriptOutput) throws IOException, TransferRestartRequest {
        Logger.fine(clazz, "result.stdout = \"" + scriptOutput.stdout + "\"");
        Logger.fine(clazz, "result.stderr = \"" + scriptOutput.stderr + "\"");
        Logger.fine(clazz, "result.rc = \"" + scriptOutput.rc + "\"");
        Map<String, FileInfo> map = DataFileScriptGenerator.getMappedFileList(list);
        Map<String, FileChunk> map2 = DataFileScriptGenerator.getMappedChunkList(list);
        if (null == scriptOutput.stdout) {
            throw new IOException("No stdout result to evaluate.");
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(scriptOutput.stdout));
        String string = null;
        for (FileChunk object : map2.values()) {
            object.setChunkCheckRequested(false);
        }
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.startsWith(PASS_TOKEN) && !string.startsWith(CHECK_CHUNK_TOKEN)) continue;
            String[] stringArray = string.split(SPACE);
            if (stringArray.length != 2) {
                throw new IOException("Invalid result log format: " + string);
            }
            String string2 = stringArray[1];
            FileInfo fileInfo = map.get(string2);
            if (fileInfo != null) {
                fileInfo.setTransferred(true);
                for (FileChunk fileChunk : fileInfo.getFileChunks()) {
                    fileChunk.setTransferred(true);
                }
                continue;
            }
            FileChunk fileChunk = map2.get(string2);
            if (fileChunk != null) {
                if (string.startsWith(PASS_TOKEN)) {
                    fileChunk.setTransferred(true);
                    continue;
                }
                if (!string.startsWith(CHECK_CHUNK_TOKEN)) continue;
                fileChunk.setChunkCheckRequested(true);
                continue;
            }
            throw new IOException("FileChunk not found: " + string2);
        }
        if (2 == scriptOutput.rc) {
            throw new TransferRestartRequest();
        }
        if (5 != scriptOutput.rc && scriptOutput.rc != 0) {
            throw new IOException(scriptOutput.stderr);
        }
    }

    public static Map<String, FileInfo> getMappedFileList(List<FileInfo> list) {
        HashMap<String, FileInfo> hashMap = new HashMap<String, FileInfo>();
        for (FileInfo fileInfo : list) {
            hashMap.put(fileInfo.getPath().getFileName().toString(), fileInfo);
        }
        return hashMap;
    }

    public static Map<String, FileChunk> getMappedChunkList(List<FileInfo> list) {
        HashMap<String, FileChunk> hashMap = new HashMap<String, FileChunk>();
        for (FileInfo fileInfo : list) {
            for (FileChunk fileChunk : fileInfo.getFileChunks()) {
                hashMap.put(fileChunk.getName(), fileChunk);
            }
        }
        return hashMap;
    }

    public static String generateChunkCheckScript(List<FileInfo> list, String string, String string2) {
        String string3 = DataFileScriptGenerator.generateScript(list, string, string2, true, true);
        string3 = string3 + "md5sum_check SourceChunkFiles\n";
        return string3;
    }
}

