/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.task;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.transfer.task.TransferTaskProgressListener;
import oracle.dbtools.util.Logger;

public class TransferTaskProgressMonitor
implements TransferTaskProgressListener {
    private TransferTaskProgressMonitor parent;
    private int op;
    private String source;
    private String destination;
    private long max;
    private volatile long count;
    private volatile long prevReportedCount;
    private boolean maxIsSet;
    private boolean taskCancelled;
    public long start;
    public volatile long prevReportedTime;
    public long reportByteInterval;
    protected DecimalFormat df = new DecimalFormat("#00.0000");
    private List<TransferTaskProgressListener> listeners = new ArrayList<TransferTaskProgressListener>();
    private long progressOffset;

    public TransferTaskProgressMonitor(TransferTaskProgressMonitor transferTaskProgressMonitor) {
        this.parent = transferTaskProgressMonitor;
    }

    public TransferTaskProgressMonitor getParent() {
        return this.parent;
    }

    public void addListener(TransferTaskProgressListener transferTaskProgressListener) {
        if (!this.listeners.contains(transferTaskProgressListener)) {
            this.listeners.add(transferTaskProgressListener);
        }
    }

    public void removeListener(TransferTaskProgressListener transferTaskProgressListener) {
        this.listeners.remove(transferTaskProgressListener);
    }

    public int getOp() {
        return this.op;
    }

    public String getOpAsString() {
        return this.op == 0 ? "put" : "get";
    }

    public String getSource() {
        return this.source;
    }

    public String getDestination() {
        return this.destination;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long l) {
        this.max += l;
        this.maxIsSet = true;
        if (this.parent != null) {
            this.parent.setMax(l);
        }
    }

    public long getCount() {
        return this.progressOffset + this.count;
    }

    public boolean isTaskCancelled() {
        return this.taskCancelled;
    }

    public void setTaskCancelled(boolean bl) {
        this.taskCancelled = bl;
    }

    @Override
    public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
        switch (raptorTaskEvent.getTaskDescriptor().getStatus()) {
            case PAUSED: {
                break;
            }
            case RUNNABLE: {
                break;
            }
            case FINISHED: {
                if (!raptorTaskEvent.getTaskDescriptor().isCancelled()) break;
                this.taskCancelled(raptorTaskEvent);
                break;
            }
            case NEW: {
                break;
            }
            case FAILED: {
                if (!raptorTaskEvent.getTaskDescriptor().isCancelled()) break;
                this.taskCancelled(raptorTaskEvent);
                break;
            }
            default: {
                throw new IllegalStateException("" + (Object)((Object)raptorTaskEvent.getTaskDescriptor().getStatus()));
            }
        }
        for (TransferTaskProgressListener transferTaskProgressListener : this.listeners) {
            transferTaskProgressListener.stateChanged(raptorTaskEvent);
        }
    }

    private void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
        this.setTaskCancelled(true);
    }

    @Override
    public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
        for (TransferTaskProgressListener transferTaskProgressListener : this.listeners) {
            transferTaskProgressListener.progressChanged(raptorTaskEvent);
        }
    }

    @Override
    public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
        for (TransferTaskProgressListener transferTaskProgressListener : this.listeners) {
            transferTaskProgressListener.messageChanged(raptorTaskEvent);
        }
    }

    public void init(int n, String string, String string2, long l) {
        if (this.parent != null) {
            this.parent.init(n, string, string2, l);
            Logger.finer(this.getClass(), this.getOpAsString() + ", " + string + ", " + string2 + ", " + l);
        } else {
            Logger.fine(this.getClass(), this.getOpAsString() + ", " + string + ", " + string2 + ", " + l);
        }
        if (!this.maxIsSet) {
            this.max += l;
        }
        for (TransferTaskProgressListener transferTaskProgressListener : this.listeners) {
            transferTaskProgressListener.init(n, string, string2, l);
        }
        if (this.start == 0L) {
            this.op = n;
            this.source = string;
            this.destination = string2;
            this.prevReportedTime = this.start = System.nanoTime();
            this.prevReportedCount = this.count;
        }
    }

    public synchronized boolean count(long l) {
        boolean bl = true;
        this.count += l;
        if (this.parent != null) {
            bl = this.parent.count(l, "TransferTaskTotal");
        }
        for (TransferTaskProgressListener transferTaskProgressListener : this.listeners) {
            transferTaskProgressListener.count(l);
        }
        if (null == this.parent && this.reportByteInterval > 0L && this.count > this.prevReportedCount + this.reportByteInterval) {
            Logger.info(this.getClass(), this.logStatus());
        }
        return bl && !this.isTaskCancelled();
    }

    private boolean count(long l, String string) {
        String string2 = this.destination;
        this.destination = string;
        boolean bl = this.count(l);
        this.destination = string2;
        return bl;
    }

    public synchronized void end() {
        if (null == this.parent) {
            if (0L == this.reportByteInterval) {
                Logger.info(this.getClass(), this.logStatus());
            } else {
                long l = this.max - 2L * this.progressOffset;
                long l2 = this.prevReportedCount + this.reportByteInterval;
                if (l < l2) {
                    Logger.info(this.getClass(), this.logStatus());
                }
            }
            Logger.fine(this.getClass(), this.getOpAsString() + ", " + this.source + ", " + this.destination + ", " + this.max);
        } else {
            Logger.finer(this.getClass(), this.getOpAsString() + ", " + this.source + ", " + this.destination + ", " + this.max);
            this.parent.end("TransferTaskTotal");
        }
        for (TransferTaskProgressListener transferTaskProgressListener : this.listeners) {
            transferTaskProgressListener.end();
        }
    }

    private void end(String string) {
        String string2 = this.destination;
        this.destination = string;
        this.end();
        this.destination = string2;
    }

    private synchronized String logStatus() {
        long l = System.nanoTime();
        double d = (double)(l - this.prevReportedTime) / 1.0E9;
        long l2 = this.count - this.prevReportedCount;
        if (0L == l2) {
            return "";
        }
        double d2 = (double)l2 / 1048576.0;
        double d3 = d2 / d;
        double d4 = (double)(l - this.start) / 1.0E9;
        double d5 = (double)this.count / 1048576.0;
        double d6 = d5 / d4;
        String string = "%s %s %s + %sMiB / %ss = %s MiB/s Total: %sMiB / %ss = %s MiB/s";
        String string2 = String.format(string, Integer.toHexString(this.hashCode()), this.parent == null ? "0" : Integer.toHexString(this.parent.hashCode()), this.destination, this.df.format(d2), this.df.format(d), this.df.format(d3), this.df.format(d5), this.df.format(d4), this.df.format(d6));
        this.prevReportedTime = l;
        this.prevReportedCount = this.count;
        return string2;
    }

    public void setProgressOffset(long l) {
        this.progressOffset = l;
        if (this.parent != null) {
            this.parent.setProgressOffset(l);
        }
    }
}

