/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.task;

import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;

public class TransferTaskByteProgressMonitor
extends TransferTaskProgressMonitor {
    RaptorTask<?> task;
    public volatile long written;
    public long start;
    public long reportByteInterval;
    public volatile long prevReportedByte;

    public TransferTaskByteProgressMonitor(RaptorTask<?> raptorTask, long l) {
        super(null);
        this.task = raptorTask;
        this.reportByteInterval = l;
    }

    @Override
    public void init(int n, String string, String string2, long l) {
        if (this.start == 0L) {
            this.prevReportedTime = this.start = System.nanoTime();
        }
    }

    @Override
    public boolean count(long l) {
        boolean bl = true;
        this.written += l;
        if (this.written >= this.prevReportedByte + this.reportByteInterval) {
            this.showStatus();
        }
        return bl;
    }

    @Override
    public void end() {
        this.showStatus();
    }

    protected void showStatus() {
        this.task.setMessage(this.getStatus());
    }

    protected String getStatus() {
        long l = System.nanoTime();
        double d = (double)(l - this.start) / 1.0E9;
        double d2 = (double)this.written / 1048576.0;
        double d3 = d2 / d;
        String string = "%sMiB / %ss = %s MiB/s";
        String string2 = String.format(string, this.df.format(d2), this.df.format(d), this.df.format(d3));
        this.prevReportedTime = l;
        this.prevReportedByte = this.written;
        return string2;
    }
}

