/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.task;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.transfer.file.FileChunk;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.file.FileSet;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.task.TransferChunkTask;
import oracle.dbtools.transfer.task.TransferEndAdminTask;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.task.TransferSubTask;
import oracle.dbtools.transfer.task.TransferTask;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.util.Logger;

public class TransferControlTask
extends TransferSubTask {
    private IRaptorTaskRunMode mode;
    private FileSet fileSet;
    private Location targetLocation;
    private String targetDir;
    private TransferTask transferTask;
    private long adminTaskSize;
    private boolean endAdminTaskQueued;
    private List<FileInfo> fileInfos = new ArrayList<FileInfo>();
    private List<FileChunk> fileChunks = new ArrayList<FileChunk>();
    private volatile int parallelismMin;
    private volatile int parallelismMax;
    private volatile int parallelism;
    private volatile int nextChunk;
    private int retryLimit = 3;
    private long begTime;
    private volatile long lastCount;
    private volatile double lastSpeed;
    private volatile long lastTime;
    private String transferId;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("-yyyyMMdd-HHmmss");
    private int workingQueueCount;
    private boolean multiSession = true;
    private Map<Location, Boolean> locationPool = new HashMap<Location, Boolean>();
    private List<Location> deadLocations = new ArrayList<Location>();
    private boolean parallelismLocked;
    private Map<FileChunk, Integer> chunkRetryCount = new HashMap<FileChunk, Integer>();
    private static DecimalFormat df = new DecimalFormat("#0.00");

    TransferControlTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, FileSet fileSet, Location location, String string2, TransferTask transferTask) {
        super(string, true, iRaptorTaskRunMode);
        this.mode = iRaptorTaskRunMode;
        this.fileSet = fileSet;
        this.targetLocation = location;
        this.setTargetDir(string2);
        this.transferTask = transferTask;
    }

    private void setTargetDir(String string) {
        this.targetDir = string;
        if (this.targetDir.indexOf("\\") != -1) {
            if (!this.targetDir.endsWith("\\")) {
                this.targetDir = this.targetDir + "\\";
            }
        } else if (!this.targetDir.endsWith("/")) {
            this.targetDir = this.targetDir + "/";
        }
    }

    @Override
    protected Void doWork() throws TaskException {
        try {
            this.initialize();
            this.determineInitialStrategy();
            this.startTransfer();
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), exception);
            throw new TaskException(exception);
        }
        return null;
    }

    private void initialize() throws IOException {
        this.initTransferId();
        this.fileSet.getLocation().connect();
        this.targetLocation.connect();
        this.locationPool.put(this.targetLocation, true);
        long l = this.fileSet.getTotalSize();
        this.adminTaskSize = (long)((double)l * 0.05);
        this.setProgressMonitor(this.transferTask.getProgressMonitor());
        this.getProgressMonitor().setMax(l + 2L * this.adminTaskSize);
        this.setMultiSession(this.transferTask.isMultiSession());
        this.setParallelism(this.transferTask.getParallelism());
        this.setParallelismLocked(this.transferTask.isParallelismLocked());
    }

    private void initTransferId() {
        this.transferId = "Transfer";
        String string = System.getProperty("HOSTNAME");
        if (string != null && !string.isEmpty()) {
            this.transferId = this.transferId + '-' + string;
        }
        this.transferId = this.transferId + DATE_FORMAT.format(new Date());
        Logger.info(this.getClass(), this.transferId);
    }

    private void determineInitialStrategy() throws IOException {
        for (FileInfo fileInfo : this.fileSet.getFileInfos(this.targetLocation, this.targetDir)) {
            this.fileInfos.add(fileInfo);
            this.fileChunks.addAll(fileInfo.getFileChunks());
        }
        this.doPreprocessingOnTarget(this.fileInfos, this.targetLocation, this.targetDir);
        for (FileInfo fileInfo : this.fileInfos) {
            if (fileInfo.isTransferred()) {
                this.getProgressMonitor().count(fileInfo.getLength());
                continue;
            }
            long l = 0L;
            for (FileChunk fileChunk : fileInfo.getFileChunks()) {
                if (!fileChunk.isTransferred()) continue;
                l += fileChunk.getSize();
            }
            this.getProgressMonitor().count(l);
        }
    }

    private void doPreprocessingOnTarget(List<FileInfo> list, Location location, String string) throws IOException {
        location.doPreProcessing(this.transferId, list, string);
    }

    private void startTransfer() throws IOException {
        this.lastTime = this.begTime = System.nanoTime();
        this.queueNextTransferTask();
        this.getProgressMonitor().setProgressOffset(this.adminTaskSize);
        this.lastCount = this.adminTaskSize;
    }

    private boolean queueFinished() {
        return this.workingQueueCount == 0;
    }

    private void queueNextTransferTask() throws IOException {
        TransferChunkTask transferChunkTask = this.getNextChunkTask();
        if (transferChunkTask != null) {
            ++this.workingQueueCount;
            this.transferTask.addTask(transferChunkTask);
        } else if (this.queueFinished() && !this.endAdminTaskQueued) {
            this.endAdminTaskQueued = true;
            this.cleanupLocationPool();
            this.queueEndAdminTask();
        }
    }

    private void queueEndAdminTask() throws IOException {
        TransferEndAdminTask transferEndAdminTask = new TransferEndAdminTask(this.transferId, this.fileInfos, this.targetLocation, this.targetDir, this.mode);
        transferEndAdminTask.getDescriptor().addListener(new RaptorTaskAdapter(){

            @Override
            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            }

            @Override
            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable = raptorTaskEvent.getThrowable();
                if (throwable != null) {
                    if (throwable instanceof TransferRestartRequest) {
                        Logger.info(this.getClass(), throwable);
                        TransferControlTask.this.restart();
                    } else {
                        Logger.severe(this.getClass(), throwable);
                    }
                }
            }

            @Override
            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                TransferControlTask.this.getProgressMonitor().count(TransferControlTask.this.adminTaskSize);
                Logger.info(this.getClass(), "parallelism=" + (TransferControlTask.this.parallelismMin - 1) + (TransferControlTask.this.parallelismLocked ? " (LOCKED)" : "-" + (TransferControlTask.this.parallelismMax - 1)));
            }
        });
        this.transferTask.addTask(transferEndAdminTask);
    }

    private TransferChunkTask getNextChunkTask() {
        while (this.nextChunk < this.fileChunks.size()) {
            FileChunk fileChunk;
            if ((fileChunk = this.fileChunks.get(this.nextChunk++)).isTransferred()) continue;
            return this.getChunkTask(fileChunk);
        }
        return null;
    }

    private TransferChunkTask getChunkTask(final FileChunk fileChunk) {
        Location location = this.getAvailableTargetLocation();
        final TransferChunkTask transferChunkTask = new TransferChunkTask(fileChunk, location, this.mode);
        FileInfo fileInfo = fileChunk.getFileInfo();
        TransferTaskProgressMonitor transferTaskProgressMonitor = fileInfo.getProgressMonitor();
        if (null == transferTaskProgressMonitor) {
            transferTaskProgressMonitor = new TransferTaskProgressMonitor(this.getProgressMonitor());
            fileInfo.setProgressMonitor(transferTaskProgressMonitor);
        }
        transferChunkTask.setProgressMonitor(new TransferTaskProgressMonitor(transferTaskProgressMonitor));
        transferChunkTask.getDescriptor().addListener(new RaptorTaskAdapter(){

            @Override
            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            }

            @Override
            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                if (raptorTaskEvent.getThrowable() != null) {
                    Logger.warn(this.getClass(), raptorTaskEvent.getThrowable());
                }
                long l = transferChunkTask.getProgressMonitor().getCount();
                TransferControlTask.this.getProgressMonitor().count(-l);
                TransferControlTask.this.locationPool.put(transferChunkTask.getTargetLocation(), true);
                TransferControlTask.this.requeue(fileChunk);
            }

            @Override
            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    TransferControlTask.this.locationPool.put(transferChunkTask.getTargetLocation(), true);
                    TransferControlTask.this.chunkFinished(fileChunk);
                }
                catch (IOException iOException) {
                    Logger.severe(this.getClass(), iOException);
                }
            }
        });
        return transferChunkTask;
    }

    public boolean isMultiSession() {
        return this.multiSession;
    }

    public void setMultiSession(boolean bl) {
        this.multiSession = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location getAvailableTargetLocation() {
        if (!this.isMultiSession() || !this.targetLocation.isCloneable()) {
            return this.targetLocation;
        }
        Location location = null;
        for (Location location2 : this.locationPool.keySet()) {
            if (!this.locationPool.get(location2).booleanValue()) continue;
            try {
                location2.connect();
                location = location2;
                break;
            }
            catch (IOException iOException) {
                this.deadLocations.add(location2);
            }
            finally {
                this.locationPool.put(location2, false);
            }
        }
        for (Location location2 : this.deadLocations) {
            this.locationPool.remove(location2);
            location2.disconnect();
        }
        this.deadLocations.clear();
        if (null == location) {
            location = this.targetLocation.clone();
            try {
                location.connect();
                this.locationPool.put(location, false);
            }
            catch (IOException iOException) {
                location = this.targetLocation;
            }
        }
        return location;
    }

    private void cleanupLocationPool() {
        for (Location location : this.locationPool.keySet()) {
            if (this.targetLocation == location) continue;
            location.disconnect();
        }
        this.locationPool.clear();
        this.locationPool.put(this.targetLocation, true);
    }

    protected synchronized void chunkFinished(FileChunk fileChunk) throws IOException {
        --this.workingQueueCount;
        long l = this.getProgressMonitor().getCount();
        long l2 = this.getProgressMonitor().getMax();
        double d = (double)(l * 100L) / (double)l2;
        if (l == this.lastCount) {
            this.queueNextTransferTask();
            return;
        }
        long l3 = System.nanoTime();
        double d2 = (double)(l3 - this.lastTime) / 1.0E9;
        double d3 = (double)(l3 - this.begTime) / 1.0E9;
        double d4 = (double)(l - this.lastCount) / d2;
        double d5 = ((double)l - (double)this.adminTaskSize) / d3;
        double d6 = 0.0;
        if (this.lastSpeed == 0.0) {
            int n;
            if (0 < this.getParallelism() && this.isParallelismLocked()) {
                Logger.info(this.getClass(), "Preset locked parallelism (" + (this.parallelism - 1) + ") 1st chunk speed: " + TransferControlTask.inByteFormat(d4));
            } else {
                boolean bl2 = this.isParallelismLocked();
                this.setParallelismLocked(false);
                int n2 = n = d4 < 4194304.0 ? 1 : 0;
                if (n != 0) {
                    this.setParallelism(5);
                } else {
                    this.setParallelism(7);
                }
                Logger.info(this.getClass(), "Determine initial parallelism (" + (this.parallelism - 1) + ") from 1st chunk speed: " + TransferControlTask.inByteFormat(d4));
                this.setParallelismLocked(bl2);
            }
            int d7 = this.getParallelism();
            for (n = 1; n < d7; ++n) {
                this.queueNextTransferTask();
            }
        } else {
            d6 = d4 * 100.0 / this.lastSpeed;
            double d7 = 20.0;
            if (d6 > 100.0 + d7 && this.getParallelism() < 9) {
                this.setParallelism(this.parallelism + 1);
                this.queueNextTransferTask();
            }
            if (d6 < 100.0 - 2.0 * d7 && this.getParallelism() > this.getMinParallelism()) {
                this.setParallelism(this.parallelism - 1);
            } else {
                this.queueNextTransferTask();
            }
            if (this.workingQueueCount == 0) {
                this.queueNextTransferTask();
            }
        }
        Logger.fine(this.getClass(), fileChunk.getName() + ", curPct=" + df.format(d) + ", parallelism=" + this.parallelism + ", " + "lastSpeed=" + TransferControlTask.inByteFormat(this.lastSpeed) + ", curSpeed =" + TransferControlTask.inByteFormat(d4) + ", pctChange=" + df.format(d6) + ", avgSpeed=" + TransferControlTask.inByteFormat(d5));
        this.lastCount = l;
        this.lastSpeed = d4;
        this.lastTime = l3;
    }

    protected boolean isParallelismLocked() {
        return this.parallelismLocked;
    }

    protected void setParallelismLocked(boolean bl) {
        this.parallelismLocked = bl;
    }

    protected int getMinParallelism() {
        return this.parallelismMin;
    }

    protected int getParallelism() {
        return this.parallelism;
    }

    protected void setParallelism(int n) {
        if (this.isParallelismLocked()) {
            return;
        }
        if (0 == this.parallelism) {
            this.parallelismMin = n;
        }
        this.parallelism = n;
        this.transferTask.setParallelism(this.parallelism);
        if (this.parallelismMin > this.parallelism) {
            this.parallelismMin = this.parallelism;
        }
        if (this.parallelismMax < this.parallelism) {
            this.parallelismMax = this.parallelism;
        }
        Logger.fine(this.getClass(), String.valueOf(this.parallelism - 1));
    }

    protected synchronized void requeue(FileChunk fileChunk) {
        if (this.retries(fileChunk) < this.retryLimit) {
            this.transferTask.addTask(this.getChunkTask(fileChunk));
        } else {
            --this.workingQueueCount;
            Logger.severe(this.getClass(), "Retry limit exhausted for: " + fileChunk.getName());
            try {
                this.queueNextTransferTask();
            }
            catch (IOException iOException) {
                Logger.severe(this.getClass(), iOException);
            }
        }
    }

    protected synchronized void restart() {
        long l = 0L;
        for (FileChunk fileChunk : this.fileChunks) {
            if (fileChunk.isTransferred()) continue;
            l -= fileChunk.getSize();
        }
        this.getProgressMonitor().count(l);
        try {
            this.lastSpeed = 0.0;
            this.nextChunk = 0;
            this.endAdminTaskQueued = false;
            this.queueNextTransferTask();
        }
        catch (IOException iOException) {
            Logger.severe(this.getClass(), iOException);
        }
    }

    private int retries(FileChunk fileChunk) {
        Integer n = this.chunkRetryCount.get(fileChunk);
        if (null == n) {
            n = 0;
        }
        this.chunkRetryCount.put(fileChunk, n + 1);
        return n;
    }

    public static String inByteFormat(double d) {
        double d2 = d / 1024.0;
        if (d2 < 1.0) {
            return df.format(d2 * 1024.0) + " B";
        }
        if ((d2 /= 1024.0) < 1.0) {
            return df.format(d2 * 1024.0) + " KiB";
        }
        if ((d2 /= 1024.0) < 1.0) {
            return df.format(d2 * 1024.0) + " MiB";
        }
        if ((d2 /= 1024.0) < 1.0) {
            return df.format(d2 * 1024.0) + " GiB";
        }
        return df.format(d2) + " TiB";
    }

    @Override
    protected void tearDown() {
        super.tearDown();
    }
}

