/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.IAuthKeepAliveStrategy;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.auth.ReAuthOnResponseStatus;
import oracle.cloudstorage.api.get.IGetContainerReply;
import oracle.cloudstorage.api.get.IGetObjectReply;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.head.IHeadObjectReply;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.jaxrs.JaxrsSessionBuilder;
import oracle.cloudstorage.api.put.IPutContainerReply;
import oracle.cloudstorage.api.put.IPutObjectReply;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.transfer.TransferMessages;
import oracle.dbtools.transfer.file.FileChunk;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.transfer.validation.DataFileScriptGenerator;
import oracle.dbtools.util.Logger;

public class OracleStorageCloudService
extends Location {
    public static final String INCLUDE_OSS = "oss.enabled";
    public static final String SERVICE_NAME_KEY = "oss.service_name";
    public static final String IDENTITY_DOMAIN_KEY = "oss.identity_domain";
    public static final String USERNAME_KEY = "oss.username";
    public static final String PASSWORD_KEY = "oss.password";
    private String serviceName;
    private String identityDomain;
    private String userName;
    private char[] userData;
    private String serviceUrl;
    private ISession session;

    public OracleStorageCloudService(String string, String string2, String string3, char[] cArray, String string4) {
        assert (string != null);
        assert (string3 != null);
        assert (cArray != null);
        assert (string4 != null);
        this.serviceName = string;
        this.identityDomain = string2;
        this.userName = string3;
        this.userData = cArray;
        this.serviceUrl = string4;
    }

    @Override
    public OracleStorageCloudService clone() {
        OracleStorageCloudService oracleStorageCloudService = new OracleStorageCloudService(this.serviceName, this.identityDomain, this.userName, this.userData, this.serviceUrl);
        return oracleStorageCloudService;
    }

    @Override
    public void connect() throws IOException {
        if (null == this.session) {
            this.session = new JaxrsSessionBuilder().session();
            IAuthReply iAuthReply = null;
            try {
                iAuthReply = this.session.auth().keepAlive((IAuthKeepAliveStrategy)new ReAuthOnResponseStatus(Status.UNAUTHORIZED, new Status[0])).url(this.serviceUrl).user(this.serviceName, this.identityDomain, this.userName).password(String.valueOf(this.userData)).send();
                if (!iAuthReply.isSuccessful()) {
                    throw new IOException(iAuthReply.getMessage());
                }
            }
            catch (InterruptedException | RetryException throwable) {
                Logger.severe(this.getClass(), String.valueOf(iAuthReply), throwable);
                throw new IOException(throwable);
            }
            Logger.info(this.getClass(), String.valueOf(this));
        }
    }

    public ISession getSession() {
        return this.session;
    }

    @Override
    public void disconnect() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        Logger.info(this.getClass(), String.valueOf(this));
    }

    @Override
    public long copy(InputStream inputStream, String string, TransferTaskProgressMonitor transferTaskProgressMonitor, CopyOption ... copyOptionArray) throws IOException {
        long l = inputStream.available();
        double d = (double)l / 1048576.0;
        Logger.info(this.getClass(), inputStream + ", " + string + ", " + Arrays.toString(copyOptionArray) + ", len=" + d + " MiB");
        String[] stringArray = string.split("/");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        IPutObjectReply iPutObjectReply = null;
        try {
            InputStreamProgressWrapper inputStreamProgressWrapper = new InputStreamProgressWrapper(inputStream, transferTaskProgressMonitor, l);
            iPutObjectReply = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)this.session.put().container(string2)).object(string3)).data((InputStream)inputStreamProgressWrapper).send();
        }
        catch (Throwable throwable) {
            Logger.severe(this.getClass(), String.valueOf(iPutObjectReply), throwable);
            throw this.asIOException(throwable);
        }
        return l;
    }

    @Override
    public String toString() {
        return this.userName + '@' + this.serviceName + ' ' + super.toString();
    }

    @Override
    public boolean doPreProcessing(String string, List<FileInfo> list, String string2) throws IOException {
        block15: {
            IPutContainerReply iPutContainerReply = null;
            try {
                String string3 = string2;
                if (string3.endsWith("/")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                iPutContainerReply = ((IPutRequestBuilder.Container)this.session.put().container(string3)).send();
                iPutContainerReply = ((IGetRequestBuilder.Container)this.session.get().container(string3)).send();
                if (!iPutContainerReply.isSuccessful()) {
                    throw new IOException(TransferMessages.format("TransferControlTask.doPreprocessingOnTarget.noTgtDir", string2));
                }
                Set set = ((IGetContainerReply)iPutContainerReply).getObjectIds();
                if (set != null && !set.isEmpty()) {
                    Map<String, FileInfo> map = DataFileScriptGenerator.getMappedFileList(list);
                    Map<String, FileChunk> map2 = DataFileScriptGenerator.getMappedChunkList(list);
                    for (String object : set) {
                        FileChunk fileChunk;
                        FileInfo fileInfo = map.get(object);
                        if (fileInfo != null) {
                            iPutContainerReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)this.session.head().container(string3)).object(object)).send();
                            if (!iPutContainerReply.isSuccessful()) continue;
                            String string4 = iPutContainerReply.getHeader(Header.eTag);
                            if (ModelUtil.areEqual(string4, fileInfo.getMd5())) {
                                fileInfo.setTransferred(true);
                                for (FileChunk fileChunk2 : fileInfo.getFileChunks()) {
                                    fileChunk2.setTransferred(true);
                                    map2.remove(fileChunk2.getName());
                                }
                            }
                        }
                        if ((fileChunk = map2.get(object)) == null || !(iPutContainerReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)this.session.head().container(string3)).object(object)).send()).isSuccessful()) continue;
                        String string5 = iPutContainerReply.getHeader(Header.eTag);
                        fileChunk.calculateMd5();
                        String string6 = fileChunk.getMd5();
                        if (!ModelUtil.areEqual(string5, string6)) continue;
                        fileChunk.setTransferred(true);
                    }
                }
                long l = 0L;
                for (FileInfo fileInfo : list) {
                    if (!fileInfo.isTransferred()) {
                        l += fileInfo.getLength();
                    }
                    if (fileInfo.getFileChunks().size() <= 1) continue;
                    for (FileChunk fileChunk : fileInfo.getFileChunks()) {
                        if (!fileChunk.isTransferred()) continue;
                        l -= fileChunk.getSize();
                    }
                }
                iPutContainerReply = this.session.head().send();
                if (!iPutContainerReply.isSuccessful()) break block15;
                try {
                    String string5 = iPutContainerReply.getHeader("x-account-meta-quota-bytes");
                    String string7 = iPutContainerReply.getHeader("x-account-bytes-used");
                    long l2 = Long.valueOf(string5);
                    long l3 = Long.valueOf(string7);
                    long l4 = l2 - l3;
                    if (l > l4) {
                        throw new IOException(TransferMessages.format("TransferControlTask.doPreprocessingOnTarget.noSpaceDetail", l, l4));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (Throwable throwable) {
                throw this.asIOException(throwable);
            }
        }
        return true;
    }

    @Override
    public void doPostProcessing(String string, List<FileInfo> list, String string2) throws IOException, TransferRestartRequest {
        IHeadObjectReply iHeadObjectReply = null;
        boolean bl = false;
        try {
            String string3 = string2;
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            for (FileInfo fileInfo : list) {
                String string4;
                String string5;
                HashMap<String, FileChunk> hashMap = new HashMap<String, FileChunk>();
                for (FileChunk fileChunk : fileInfo.getFileChunks()) {
                    hashMap.put(fileChunk.getName(), fileChunk);
                }
                for (FileChunk fileChunk : fileInfo.getFileChunks()) {
                    iHeadObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)this.session.head().container(string3)).object(fileChunk.getName())).send();
                    if (!iHeadObjectReply.isSuccessful()) continue;
                    string5 = iHeadObjectReply.getHeader(Header.eTag);
                    fileChunk.calculateMd5();
                    string4 = fileChunk.getMd5();
                    if (!ModelUtil.areEqual(string5, string4)) continue;
                    fileChunk.setTransferred(true);
                    hashMap.remove(fileChunk.getName());
                }
                if (hashMap.isEmpty()) {
                    if (fileInfo.getFileChunks().size() <= 1) continue;
                    String string6 = fileInfo.getPath().getFileName().toString();
                    String string7 = string3 + '/' + (String)string6 + '-';
                    string5 = fileInfo.getMd5();
                    string4 = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)((IPutRequestBuilder.Header)((IPutRequestBuilder.Header)this.session.put().header((Iterable)Header.dynamicLargeObjectManifest.provide((Object)string7))).header((Iterable)Header.dynamicLargeObjectMd5.provide((Object)string5))).container(string3)).object(string6)).encrypt(false).data((InputStream)null).send();
                    if (!string4.isSuccessful()) {
                        bl = true;
                    }
                    fileInfo.setTransferred(true);
                    continue;
                }
                bl = true;
            }
        }
        catch (Throwable throwable) {
            throw this.asIOException(throwable);
        }
        if (bl) {
            throw new TransferRestartRequest();
        }
    }

    @Override
    public InputStream asInputStream(Path path, long l, long l2) throws IOException {
        InputStream inputStream = null;
        String string = path.getFileName().toString();
        String string2 = path.getParent().getFileName().toString();
        try {
            IGetObjectReply iGetObjectReply = ((IGetRequestBuilder.Object)((IGetRequestBuilder.Container)this.session.get().container(string2)).object(string)).send();
            inputStream = iGetObjectReply.getData();
        }
        catch (Throwable throwable) {
            throw this.asIOException(throwable);
        }
        return inputStream;
    }

    @Override
    public ScriptOutput logExecuteScript(String string, String string2, String string3, String string4) {
        return null;
    }

    private IOException asIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable);
    }

    class InputStreamProgressWrapper
    extends FilterInputStream {
        protected volatile TransferTaskProgressMonitor progressMonitor;
        private int mark;

        InputStreamProgressWrapper(InputStream inputStream, TransferTaskProgressMonitor transferTaskProgressMonitor, long l) {
            super(inputStream);
            assert (transferTaskProgressMonitor != null);
            this.progressMonitor = transferTaskProgressMonitor;
            this.progressMonitor.init(0, null, null, l);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.progressMonitor.end();
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            this.progressMonitor.count(n3);
            return n3;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            int n = super.read(byArray);
            return n;
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = super.skip(l);
            this.progressMonitor.count(l2);
            return l2;
        }

        @Override
        public synchronized void mark(int n) {
            this.mark = n;
            Logger.info(this.getClass(), "" + n);
            super.mark(n);
        }

        @Override
        public boolean markSupported() {
            Logger.info(this.getClass(), "=" + super.markSupported());
            return super.markSupported();
        }

        @Override
        public synchronized void reset() throws IOException {
            long l = this.progressMonitor.getCount() - (long)this.mark;
            this.progressMonitor.count(-l);
            Logger.info(this.getClass(), "" + -l);
            super.reset();
        }
    }
}

