/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.util.Logger;

public class Location {
    private static Location LOCAL;
    private static DecimalFormat df;
    private static ByteBuffer CHUNK_SIZE_BYTE_BUF;

    protected Location() {
    }

    public static Location getLocal() {
        if (null == LOCAL) {
            LOCAL = new Location();
        }
        return LOCAL;
    }

    public boolean isCloneable() {
        return true;
    }

    public Location clone() {
        return new Location();
    }

    public void connect() throws IOException {
        Logger.info(this.getClass(), String.valueOf(this));
    }

    public void disconnect() {
        Logger.info(this.getClass(), String.valueOf(this));
    }

    public InputStream asInputStream(Path path, long l, long l2) throws IOException {
        Logger.fine(this.getClass(), path + ", pos=" + l + ", size=" + l2);
        assert (l2 < Integer.MAX_VALUE);
        byte[] byArray = new byte[(int)l2];
        ByteArrayInputStream byteArrayInputStream = null;
        int n = Location.readBytes(path, l, l2, byArray);
        byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
        Logger.fine(this.getClass(), n + " bytes available in " + byteArrayInputStream);
        return byteArrayInputStream;
    }

    public long copy(InputStream inputStream, String string, TransferTaskProgressMonitor transferTaskProgressMonitor, CopyOption ... copyOptionArray) throws IOException {
        Logger.fine(this.getClass(), inputStream + ", " + string + ", " + Arrays.toString(copyOptionArray));
        if (transferTaskProgressMonitor != null) {
            transferTaskProgressMonitor.init(0, null, string, inputStream.available());
        }
        long l = Files.copy(inputStream, Paths.get(string, new String[0]), copyOptionArray);
        if (transferTaskProgressMonitor != null) {
            transferTaskProgressMonitor.count(l);
            transferTaskProgressMonitor.end();
        }
        Logger.fine(this.getClass(), l + " bytes written");
        return l;
    }

    public boolean verifySize(String string, long l) {
        Logger.fine(this.getClass(), string + ", size=" + l);
        boolean bl = l == new File(string).length();
        Logger.fine(this.getClass(), String.valueOf(bl));
        return bl;
    }

    public ScriptOutput logExecuteScript(String string, String string2, String string3, String string4) {
        long l = System.nanoTime();
        ScriptOutput scriptOutput = this.executeScript(string2, string3, string4);
        double d = (double)(System.nanoTime() - l) / 1.0E9;
        Logger.info(this.getClass(), string + " r/c: " + scriptOutput.rc + " in " + df.format(d) + " seconds");
        if (scriptOutput.rc != 0 && scriptOutput.rc != 7) {
            Logger.warn(this.getClass(), string + " stderr:\n" + scriptOutput.stderr + "\n stdout:\n" + scriptOutput.stdout);
        }
        return scriptOutput;
    }

    public ScriptOutput executeScript(String string, String string2, String string3) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MD5 getMd5(Path path, long l, long l2) {
        assert (l2 < Integer.MAX_VALUE);
        MD5 mD5 = new MD5();
        ByteBuffer byteBuffer = CHUNK_SIZE_BYTE_BUF;
        synchronized (byteBuffer) {
            ByteBuffer byteBuffer2 = CHUNK_SIZE_BYTE_BUF;
            if (l2 != (long)byteBuffer2.capacity()) {
                byteBuffer2 = ByteBuffer.allocate((int)l2);
            }
            try (FileInputStream fileInputStream = new FileInputStream(path.toString());
                 FileChannel fileChannel = fileInputStream.getChannel();){
                fileChannel.read(byteBuffer2, l);
                byteBuffer2.flip();
                mD5.calculate(byteBuffer2);
                byteBuffer2.clear();
            }
            catch (IOException iOException) {
                Logger.severe(this.getClass(), iOException);
                return null;
            }
        }
        return mD5;
    }

    private static int readBytes(Path path, long l, long l2, byte[] byArray) throws IOException {
        assert (l2 == (long)byArray.length);
        int n = 0;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(path.toString()));){
            bufferedInputStream.skip(l);
            n = bufferedInputStream.read(byArray, 0, (int)l2);
            Logger.fine(Location.class, n + " bytes available in " + byArray);
        }
        return n;
    }

    public String toString() {
        if (LOCAL == this) {
            String string = System.getProperty("HOSTNAME");
            return string + ": " + super.toString();
        }
        return super.toString();
    }

    public boolean doPreProcessing(String string, List<FileInfo> list, String string2) throws IOException {
        return true;
    }

    public void doPostProcessing(String string, List<FileInfo> list, String string2) throws IOException, TransferRestartRequest {
    }

    static {
        df = new DecimalFormat("#0.0000");
        CHUNK_SIZE_BYTE_BUF = ByteBuffer.allocateDirect((int)FileInfo.CHUNK_SIZE);
    }
}

