/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import oracle.dbtools.transfer.TransferMessages;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.transfer.validation.DataFileScriptGenerator;
import oracle.dbtools.util.Logger;

public class JSchLocation
extends Location {
    private static final JSch jsch = new JSch();
    private String host;
    private int port;
    private String user;
    private String keyFile;
    private String userData;
    private int timeout = 15000;
    protected Session session;

    public Session getSession() {
        return this.session;
    }

    public JSchLocation(String string, int n, String string2, String string3) {
        this.host = string;
        this.port = n;
        this.user = string2;
        this.keyFile = string3;
    }

    protected JSchLocation() {
    }

    protected void init(Session session) {
        this.host = session.getHost();
        this.port = session.getPort();
        this.user = session.getUserName();
    }

    @Override
    public void connect() throws IOException {
        try {
            this.connectImpl();
            Logger.fine(this.getClass(), String.valueOf(this));
        }
        catch (Exception exception) {
            String string = "Unable to connect";
            Logger.severe(this.getClass(), string, exception);
            throw new IOException(string, exception);
        }
    }

    protected void connectImpl() throws JSchException {
        if (null == this.session) {
            throw new UnsupportedOperationException("Password must be set before calling connect");
        }
        if (!this.session.isConnected()) {
            this.session.setConfig("StrictHostKeyChecking", "no");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("cipher.s2c", "aes128-ctr,aes192-ctr");
            hashtable.put("cipher.c2s", "aes128-ctr,aes192-ctr");
            hashtable.put("CheckCiphers", "");
            this.session.setConfig(hashtable);
            this.session.setServerAliveInterval(this.timeout);
            this.session.setTimeout(this.timeout);
            this.session.connect(this.timeout);
            Logger.info(this.getClass(), String.valueOf(this));
        }
    }

    public void setPassword(String string) throws IOException {
        try {
            if (null == this.session) {
                if (this.keyFile != null && !this.keyFile.isEmpty() && !jsch.getIdentityNames().contains(this.keyFile)) {
                    jsch.addIdentity(new File(this.keyFile).getAbsolutePath(), string);
                }
                this.session = jsch.getSession(this.user, this.host, this.port);
                if (null == this.keyFile || this.keyFile.isEmpty()) {
                    this.session.setPassword(string);
                    this.userData = string;
                }
                string = null;
                Logger.fine(this.getClass(), "Session created: " + String.valueOf(this.session));
            }
        }
        catch (Exception exception) {
            String string2 = "Unable to create session";
            Logger.severe(this.getClass(), string2, exception);
            throw new IOException(string2, exception);
        }
    }

    @Override
    public JSchLocation clone() {
        JSchLocation jSchLocation = new JSchLocation(this.host, this.port, this.user, this.keyFile);
        try {
            jSchLocation.setPassword(this.userData);
        }
        catch (IOException iOException) {
            Logger.severe(this.getClass(), "Unable to get new session");
            jSchLocation = null;
        }
        return jSchLocation;
    }

    @Override
    public void disconnect() {
        if (this.session != null) {
            this.session.disconnect();
            Logger.fine(this.getClass(), String.valueOf(this));
        }
    }

    @Override
    public InputStream asInputStream(Path path, long l, long l2) throws IOException {
        throw new UnsupportedOperationException("Target usage only! TODO: Support as source?");
    }

    @Override
    public MD5 getMd5(Path path, long l, long l2) {
        throw new UnsupportedOperationException("Target usage only! TODO: Support as source?");
    }

    public long copy(InputStream inputStream, String string, CopyOption ... copyOptionArray) throws IOException {
        return this.copy(inputStream, string, (TransferTaskProgressMonitor)null, copyOptionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long copy(InputStream inputStream, String string, TransferTaskProgressMonitor transferTaskProgressMonitor, CopyOption ... copyOptionArray) throws IOException {
        long l;
        Logger.fine(this.getClass(), inputStream + ", " + string + ", " + Arrays.toString(copyOptionArray));
        assert (this.session != null && this.session.isConnected());
        int n = SftpCopyOption.OVERWRITE.sftpCode();
        if (copyOptionArray != null && copyOptionArray.length > 0 && StandardCopyOption.REPLACE_EXISTING != copyOptionArray[0]) {
            n = ((SftpCopyOption)copyOptionArray[0]).sftpCode();
        }
        JSchProgressMonitor jSchProgressMonitor = new JSchProgressMonitor(transferTaskProgressMonitor);
        ChannelSftp channelSftp = null;
        try {
            Session session = this.session;
            synchronized (session) {
                assert (this.session != null && this.session.isConnected());
                channelSftp = (ChannelSftp)this.session.openChannel("sftp");
            }
            channelSftp.connect();
            l = 0L;
            try {
                l = channelSftp.lstat(string).getSize();
                if (l > 0L) {
                    Logger.info(this.getClass(), string + " exists, skipping " + l + " bytes.");
                    inputStream.skip(l);
                    n = SftpCopyOption.APPEND.sftpCode();
                }
            }
            catch (Exception exception) {
                Logger.ignore(this.getClass(), exception);
            }
            channelSftp.put(inputStream, string, (SftpProgressMonitor)jSchProgressMonitor, n);
        }
        catch (Exception exception) {
            String string2 = "Unable to copy to " + string;
            Logger.fine(this.getClass(), string2, exception);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(string2, exception);
        }
        finally {
            if (channelSftp != null && channelSftp.isConnected()) {
                channelSftp.disconnect();
            }
        }
        l = jSchProgressMonitor.written;
        Logger.fine(this.getClass(), l + " bytes written");
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyExecutable(ByteArrayInputStream byteArrayInputStream, String string) throws IOException {
        Logger.fine(this.getClass(), byteArrayInputStream + ", " + string);
        assert (this.session != null && this.session.isConnected());
        int n = SftpCopyOption.OVERWRITE.sftpCode();
        JSchProgressMonitor jSchProgressMonitor = new JSchProgressMonitor(null);
        ChannelSftp channelSftp = null;
        try {
            Session session = this.session;
            synchronized (session) {
                assert (this.session != null && this.session.isConnected());
                channelSftp = (ChannelSftp)this.session.openChannel("sftp");
            }
            channelSftp.connect();
            channelSftp.put((InputStream)byteArrayInputStream, string, (SftpProgressMonitor)jSchProgressMonitor, n);
            channelSftp.chmod(510, string);
        }
        catch (Exception exception) {
            String string2 = "Unable to copy to " + string;
            Logger.fine(this.getClass(), string2, exception);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(string2, exception);
        }
        finally {
            if (channelSftp != null && channelSftp.isConnected()) {
                channelSftp.disconnect();
            }
        }
        long l = jSchProgressMonitor.written;
        Logger.fine(this.getClass(), l + " bytes written");
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifySize(String string, long l) {
        Logger.fine(this.getClass(), string + ", size=" + l);
        ChannelSftp channelSftp = null;
        boolean bl = false;
        try {
            channelSftp = (ChannelSftp)this.session.openChannel("sftp");
            channelSftp.connect();
            bl = l == channelSftp.stat(string).getSize();
        }
        catch (JSchException jSchException) {
            Logger.severe(this.getClass(), "Unable to open sftp channel.", jSchException);
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), "Unable to stat size.", exception);
        }
        finally {
            if (channelSftp != null && channelSftp.isConnected()) {
                channelSftp.disconnect();
            }
        }
        Logger.fine(this.getClass(), String.valueOf(bl));
        return bl;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public String getTargetScript(List<FileInfo> list) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptOutput executeScript(String string, String string2, String string3) {
        assert (string != null);
        Logger.finer(this.getClass(), "script = \"" + string + "\"");
        String string4 = string + "\nexit $?\n";
        ChannelShell channelShell = null;
        ScriptOutput scriptOutput = new ScriptOutput();
        try {
            Object object = this.session;
            synchronized (object) {
                assert (this.session != null && this.session.isConnected());
                channelShell = (ChannelShell)this.session.openChannel("shell");
            }
            object = new ByteArrayInputStream(string4.getBytes());
            String string5 = string3 + string2;
            this.copyExecutable((ByteArrayInputStream)object, string5);
            string4 = string5 + "\nexit $?\n";
            object = new ByteArrayInputStream(string4.getBytes());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(2048);
            channelShell.setInputStream((InputStream)object);
            channelShell.setOutputStream((OutputStream)byteArrayOutputStream);
            channelShell.setExtOutputStream((OutputStream)byteArrayOutputStream2);
            channelShell.connect(this.timeout);
            do {
                Thread.sleep(125L);
            } while (!channelShell.isEOF());
            scriptOutput.stdout = byteArrayOutputStream.toString();
            scriptOutput.stderr = byteArrayOutputStream2.toString();
            scriptOutput.rc = channelShell.getExitStatus();
            channelShell.disconnect();
        }
        catch (JSchException jSchException) {
            Logger.severe(this.getClass(), "Unable to open shell channel.", jSchException);
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), "Unable to execute script.", exception);
        }
        return scriptOutput;
    }

    @Override
    public String toString() {
        return this.user + '@' + this.host + ' ' + super.toString();
    }

    @Override
    public boolean doPreProcessing(String string, List<FileInfo> list, String string2) throws IOException {
        String string3 = string + ".log";
        String string4 = string + ".bash";
        ScriptOutput scriptOutput = null;
        try {
            String string5 = DataFileScriptGenerator.generatePreTransferScript(list, string2, string3);
            scriptOutput = this.logExecuteScript("doPreprocessingOnTarget", string5, string4, string2);
            DataFileScriptGenerator.evaluate(list, scriptOutput);
            if (scriptOutput.rc == 5) {
                string5 = DataFileScriptGenerator.generateChunkCheckScript(list, string2, string3);
                scriptOutput = this.logExecuteScript("doRequestedChunkChecks", string5, string4, string2);
                DataFileScriptGenerator.evaluate(list, scriptOutput);
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            String string6 = TransferMessages.getString("TransferControlTask.doPreprocessingOnTarget.fail");
            if (scriptOutput != null && scriptOutput.rc == 6) {
                string6 = TransferMessages.getString("TransferControlTask.doPreprocessingOnTarget.noSpace");
                throw new IOException(string6, throwable);
            }
            if (scriptOutput == null || scriptOutput.rc != 7) {
                Logger.warn(this.getClass(), string6, throwable);
            }
            return false;
        }
    }

    @Override
    public void doPostProcessing(String string, List<FileInfo> list, String string2) throws IOException, TransferRestartRequest {
        String string3 = string + ".log";
        String string4 = string + ".bash";
        String string5 = DataFileScriptGenerator.generatePostTransferScript(list, string2, string3);
        ScriptOutput scriptOutput = this.logExecuteScript("doPostprocessingOnTarget", string5, string4, string2);
        DataFileScriptGenerator.evaluate(list, scriptOutput);
    }

    public static enum SftpCopyOption implements CopyOption
    {
        OVERWRITE(0),
        RESUME(1),
        APPEND(2);

        private int code;

        private SftpCopyOption(int n2) {
            this.code = n2;
        }

        public int sftpCode() {
            return this.code;
        }
    }

    public static class JSchProgressMonitor
    implements SftpProgressMonitor {
        SftpProgressMonitor monitor;
        public volatile long written;
        public String target;
        public long max;
        public long start;
        public volatile long prevReportedByte;
        public volatile long prevReportedTime;
        private DecimalFormat df = new DecimalFormat("#00.0000");

        public JSchProgressMonitor(SftpProgressMonitor sftpProgressMonitor) {
            this.monitor = sftpProgressMonitor;
        }

        public void init(int n, String string, String string2, long l) {
            Logger.fine(this.getClass(), "sftp upload: " + string2);
            this.target = string2;
            if (this.start == 0L) {
                this.prevReportedTime = this.start = System.nanoTime();
            }
            if (this.monitor != null) {
                this.monitor.init(n, string, string2, l);
            }
        }

        public boolean count(long l) {
            boolean bl = true;
            if (this.monitor != null) {
                bl = this.monitor.count(l);
            }
            this.written += l;
            if (this.max > 0L && this.written > this.max / 2L) assert (l >= 0L || l <= 0L);
            return bl;
        }

        public void end() {
            if (null == this.monitor) {
                this.logStatus();
            } else {
                this.monitor.end();
            }
        }

        private void logStatus() {
            long l = System.nanoTime();
            double d = (double)(l - this.prevReportedTime) / 1.0E9;
            double d2 = ((double)this.written - (double)this.prevReportedByte) / 1048576.0;
            double d3 = d2 / d;
            double d4 = (double)(l - this.start) / 1.0E9;
            double d5 = (double)this.written / 1048576.0;
            double d6 = d5 / d4;
            String string = "%s %s %s + %sMiB / %ss = %s MiB/s Total: %sMiB / %ss = %s MiB/s";
            String string2 = String.format(string, Integer.toHexString(this.hashCode()), this.monitor == null ? "0" : Integer.toHexString(this.monitor.hashCode()), this.target, this.df.format(d2), this.df.format(d), this.df.format(d3), this.df.format(d5), this.df.format(d4), this.df.format(d6));
            Logger.info(this.getClass(), string2);
            this.prevReportedTime = l;
            this.prevReportedByte = this.written;
        }
    }
}

