/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.file;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.location.Location;

public class FileSet {
    private List<Path> paths = new ArrayList<Path>();
    private Location location;
    private long totalSize;
    private static Comparator<FileInfo> fileInfoSizeComparator = new Comparator<FileInfo>(){

        @Override
        public int compare(FileInfo fileInfo, FileInfo fileInfo2) {
            if (fileInfo.getLength() < fileInfo2.getLength()) {
                return -1;
            }
            if (fileInfo.getLength() > fileInfo2.getLength()) {
                return 1;
            }
            return 0;
        }
    };
    private List<FileInfo> fileInfos = new ArrayList<FileInfo>();

    public FileSet() {
    }

    public FileSet(Location location, Collection<String> collection) {
        this.setLocation(location);
        for (String string : collection) {
            this.add(string);
        }
    }

    public void add(String string) {
        this.paths.add(Paths.get(string, new String[0]));
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public long getTotalSize() {
        if (0L == this.totalSize) {
            for (Path path : this.getPaths()) {
                this.totalSize += path.toFile().length();
            }
        }
        return this.totalSize;
    }

    public List<FileInfo> getFileInfos(Location location, String string) {
        if (this.fileInfos.isEmpty()) {
            for (Path path : this.getPaths()) {
                FileInfo fileInfo = new FileInfo(path, this.getLocation(), location, string);
                this.fileInfos.add(fileInfo);
            }
            FileInfo[] fileInfoArray = this.fileInfos.toArray(new FileInfo[0]);
            Arrays.sort(fileInfoArray, fileInfoSizeComparator);
            this.fileInfos.clear();
            this.fileInfos.addAll(Arrays.asList(fileInfoArray));
        }
        return this.fileInfos;
    }

    public String asJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{').append("\"fileInfos\":[\n");
        String string = "   ";
        boolean bl = true;
        for (FileInfo fileInfo : this.fileInfos) {
            String[] stringArray;
            int n = bl ? 32 : 44;
            for (String string2 : stringArray = fileInfo.asJson().split("\n")) {
                stringBuilder.append(string).append((char)n).append(string2).append('\n');
                n = 32;
            }
            bl = false;
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }
}

