/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.file;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.transfer.file.FileChunk;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.task.TransferTaskProgressListener;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.util.Logger;

public class FileInfo {
    private Path path;
    private Location sourceLocation;
    private Location targetLocation;
    private String targetDir;
    private List<FileChunk> fileChunks;
    private static long TEN_MB;
    public static long CHUNK_SIZE;
    private MD5 md5;
    private boolean transferred;
    private long length;
    public static final char SUFFIX_SEPARATOR = '-';
    private static DecimalFormat df;
    private List<TransferTaskProgressListener> listeners = new ArrayList<TransferTaskProgressListener>();
    private TransferTaskProgressMonitor progressMonitor;

    private FileInfo() {
    }

    public FileInfo(Path path, Location location, Location location2, String string) {
        Logger.info(this.getClass(), path.toString() + ", " + location2);
        this.path = path;
        this.sourceLocation = location;
        this.targetLocation = location2;
        this.targetDir = string;
        this.fileChunks = new ArrayList<FileChunk>();
        this.md5 = new MD5();
    }

    public Path getPath() {
        return this.path;
    }

    public Location getSourceLocation() {
        return this.sourceLocation;
    }

    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public long getLength() {
        if (0L == this.length) {
            this.length = this.path.toFile().length();
        }
        return this.length;
    }

    public List<FileChunk> getFileChunks() {
        if (this.fileChunks.isEmpty()) {
            this.initFileChunks(CHUNK_SIZE);
        }
        return this.fileChunks;
    }

    public void initFileChunks(long l) {
        long l2 = this.getLength();
        if (l < 0L) {
            l = l2;
        }
        int n = (int)(l2 / l);
        if ((long)((int)l2) % l != 0L) {
            ++n;
        }
        String string = this.path.getFileName().toString();
        for (int i = 0; i < n; ++i) {
            String string2 = string + this.getSuffix(i);
            long l3 = l * (long)i;
            long l4 = 0L;
            l4 = i < n - 1 ? l : l2 - l3;
            this.fileChunks.add(new FileChunk(this, string2, this.targetDir, l3, l4));
        }
    }

    private String getSuffix(int n) {
        assert (n < 15625);
        char[] cArray = new char[4];
        cArray[0] = 45;
        cArray[3] = (char)(n % 25 + 97);
        cArray[2] = (char)((n /= 25) % 25 + 97);
        cArray[1] = (char)((n /= 25) % 25 + 97);
        return new String(cArray);
    }

    public String getMd5() {
        long l = System.nanoTime();
        if (this.md5.getValue() == null) {
            this.md5.calculate(this.getPath().toString());
        }
        double d = (double)(System.nanoTime() - l) / 1.0E9;
        Logger.info(this.getClass(), df.format(d) + " seconds");
        return this.md5.getValue();
    }

    public boolean isTransferred() {
        return this.transferred;
    }

    public void setTransferred(boolean bl) {
        this.transferred = bl;
    }

    public static String csvHeader() {
        return "Name,Path,md5";
    }

    public String csvRow() {
        return '\"' + this.path.getFileName().toString() + "\",\"" + this.path.toString() + "\",\"" + this.getMd5() + '\"';
    }

    public String asJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{').append("\"name\":\"").append(this.path.getFileName().toString()).append('\"').append(',').append("\"path\":\"").append(this.path.toString()).append('\"').append(',').append("\"targetDir\":\"").append(this.targetDir).append('\"').append(',').append("\"transferred\":").append(this.transferred).append(',').append("\"md5\":\"").append(this.getMd5()).append('\"').append("\n,").append("\"fileChunks\":[\n");
        String string = "    ";
        for (FileChunk fileChunk : this.getFileChunks()) {
            String[] stringArray;
            for (String string2 : stringArray = fileChunk.asJson().split("\n")) {
                stringBuilder.append(string).append(string2).append('\n');
            }
            string = "   ,";
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    public InputStream asInputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.path.toString()), 13);
    }

    public void addListener(TransferTaskProgressListener transferTaskProgressListener) {
        if (!this.listeners.contains(transferTaskProgressListener)) {
            this.listeners.add(transferTaskProgressListener);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.addListener(transferTaskProgressListener);
        }
    }

    public void removeListener(TransferTaskProgressListener transferTaskProgressListener) {
        this.listeners.remove(transferTaskProgressListener);
        if (this.progressMonitor != null) {
            this.progressMonitor.removeListener(transferTaskProgressListener);
        }
    }

    public TransferTaskProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(TransferTaskProgressMonitor transferTaskProgressMonitor) {
        this.progressMonitor = transferTaskProgressMonitor;
        if (transferTaskProgressMonitor != null) {
            for (TransferTaskProgressListener transferTaskProgressListener : this.listeners) {
                transferTaskProgressMonitor.addListener(transferTaskProgressListener);
            }
        }
    }

    static {
        CHUNK_SIZE = TEN_MB = 0xA00000L;
        df = new DecimalFormat("#0.0000");
    }
}

