/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.file;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.util.Logger;

public class FileChunk {
    private FileInfo fileInfo;
    private String name;
    String targetDir;
    private long offset;
    private long size;
    private MD5 md5;
    private boolean transferred;
    private boolean chunkCheckRequested;

    private FileChunk() {
    }

    public FileChunk(FileInfo fileInfo, String string, String string2, long l, long l2) {
        Logger.fine(this.getClass(), fileInfo + ", " + string + ", " + l + ", " + l2);
        this.fileInfo = fileInfo;
        this.name = string;
        this.targetDir = string2;
        this.offset = l;
        this.size = l2;
        this.md5 = null;
    }

    public String getName() {
        if (this.isCompleteFile()) {
            return this.fileInfo.getPath().getFileName().toString();
        }
        return this.name;
    }

    public String getTargetPath() {
        return this.targetDir + this.getName();
    }

    public String getMd5() {
        return null == this.md5 ? null : this.md5.getValue();
    }

    public void calculateMd5() {
        if (null == this.md5) {
            this.md5 = this.isCompleteFile() ? new MD5(this.fileInfo.getMd5()) : this.fileInfo.getSourceLocation().getMd5(this.fileInfo.getPath(), this.offset, this.size);
        }
    }

    public boolean isTransferred() {
        return this.transferred;
    }

    public void setTransferred(boolean bl) {
        this.transferred = bl;
    }

    public InputStream asInputStream() throws IOException {
        if (this.isCompleteFile()) {
            return this.fileInfo.asInputStream();
        }
        return this.fileInfo.getSourceLocation().asInputStream(this.fileInfo.getPath(), this.offset, this.size);
    }

    public static String csvHeader() {
        return "Name,Offset,Size,md5";
    }

    public String csvRow() {
        return '\"' + this.name + "\"," + this.offset + ',' + this.size + "\",\"" + (null == this.md5 ? null : this.md5.getValue()) + '\"';
    }

    public String asJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{').append("\"name\":\"").append(this.name).append('\"').append(',').append("\"offset\":").append(this.offset).append(',').append("\"size\":").append(this.size).append(',').append("\"md5\":\"").append(null == this.md5 ? "" : this.md5.getValue()).append('\"').append('}');
        return stringBuilder.toString();
    }

    public long getSize() {
        return this.size;
    }

    private boolean isCompleteFile() {
        return this.offset == 0L && this.size == this.fileInfo.getLength();
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setChunkCheckRequested(boolean bl) {
        this.chunkCheckRequested = bl;
    }

    public boolean isChunkCheckRequested() {
        return this.chunkCheckRequested;
    }
}

