/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer;

import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.transfer.file.FileSet;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.task.TransferTask;

public class TransferManager {
    public static TransferManager INSTANCE = new TransferManager();
    Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    private TransferManager() {
    }

    public TransferTask createTransferTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, FileSet fileSet, Location location, String string2) {
        TransferTask transferTask = new TransferTask(string, iRaptorTaskRunMode, fileSet, location, string2);
        return transferTask;
    }

    public void setPackageLogStream(OutputStream outputStream, boolean bl) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS %4$-6s %2$s %5$s%6$s%n");
        StreamHandler streamHandler = new StreamHandler(outputStream, new SimpleFormatter(){

            @Override
            public synchronized String format(LogRecord logRecord) {
                return Thread.currentThread().toString() + " " + super.format(logRecord);
            }
        }){

            @Override
            public synchronized void publish(LogRecord logRecord) {
                super.publish(logRecord);
                this.flush();
            }
        };
        this.logger.addHandler(streamHandler);
        this.logger.setUseParentHandlers(bl);
        String string = outputStream == System.out ? "System.out" : (outputStream == System.err ? "System.err" : String.valueOf(outputStream));
        oracle.dbtools.util.Logger.info(this.getClass(), string + ", useParentHandlers=" + bl);
    }

    public void setPackageLogLevel(Level level) {
        oracle.dbtools.util.Logger.info(this.getClass(), String.valueOf(level));
        this.logger.setLevel(level);
    }
}

