/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLHelper {
    private static DocumentBuilderFactory factory = null;
    private static DocumentBuilder builder = null;
    private static Document document = null;
    private static Element root = null;

    public static Node getChildNode(Node node, String string) {
        try {
            if (node == null || string == null) {
                return null;
            }
            NodeList nodeList = ((XMLNode)node).getChildNodes();
            Node node2 = null;
            String string2 = string.indexOf("/") == 0 ? string.substring(1) : string;
            for (int i = 0; node2 == null && i < nodeList.getLength(); ++i) {
                if (!nodeList.item(i).getNodeName().equals(string2)) continue;
                node2 = nodeList.item(i);
            }
            return node2;
        }
        catch (Exception exception) {
            Logger.getLogger(XMLHelper.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    public static XMLNode[] getChildNodes(Node node, String string) {
        XMLNode[] xMLNodeArray = null;
        try {
            NodeList nodeList = ((XMLNode)node).getChildNodes();
            ArrayList<XMLNode> arrayList = new ArrayList<XMLNode>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!nodeList.item(i).getNodeName().equalsIgnoreCase(string)) continue;
                arrayList.add((XMLNode)nodeList.item(i));
            }
            if (arrayList.size() > 0) {
                xMLNodeArray = new XMLNode[arrayList.size()];
                arrayList.toArray(xMLNodeArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xMLNodeArray != null ? xMLNodeArray : new XMLNode[]{};
    }

    public static String getNodeValue(Node node, String string) {
        String string2 = null;
        if (node != null) {
            Node node2 = XMLHelper.getChildNode(node, string);
            if (node2 == null) {
                return "";
            }
            Node node3 = node2.getFirstChild();
            if (node3 instanceof Text) {
                string2 = ((Text)node3).getTextContent();
            }
            string2 = node3 != null ? node3.getNodeValue() : node2.getNodeValue();
        }
        return string2;
    }

    public static String getAttributeNode(Node node, String string) {
        String string2 = null;
        try {
            if (node != null) {
                Node node2;
                String string3;
                String string4 = string3 = string.startsWith("@") ? string.substring(1) : string;
                if (node.getAttributes() != null && (node2 = node.getAttributes().getNamedItem(string3)) != null) {
                    string2 = node2.getNodeValue();
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(XMLHelper.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string2;
    }

    public static Element NewDocument() {
        try {
            factory = DocumentBuilderFactory.newInstance();
            factory.setCoalescing(true);
            builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            root = document.createElement("reports");
            document.appendChild(root);
            return root;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger(XMLHelper.class.getName()).info(parserConfigurationException.toString());
            return null;
        }
    }

    public static Element addFolder(Element element, String string, String string2, String string3) {
        Element element2 = document.createElement("folder");
        Element element3 = document.createElement("name");
        element3.appendChild(document.createCDATASection(string.trim()));
        element2.appendChild(element3);
        Element element4 = document.createElement("description");
        element4.appendChild(document.createCDATASection(string2.trim()));
        element2.appendChild(element4);
        Element element5 = document.createElement("tooltip");
        element5.appendChild(document.createCDATASection(string3.trim()));
        element2.appendChild(element5);
        element.appendChild(element2);
        return element2;
    }

    public static void addReport(Element element, String string, String string2, String string3, String string4) {
        Element element2 = document.createElement("report");
        element2.setAttribute("type", "report");
        element2.setAttribute("enabled", "true");
        Element element3 = document.createElement("name");
        element3.appendChild(document.createCDATASection(string.trim()));
        element2.appendChild(element3);
        Element element4 = document.createElement("description");
        element4.appendChild(document.createCDATASection(string2.trim()));
        element2.appendChild(element4);
        Element element5 = document.createElement("tooltip");
        element5.appendChild(document.createCDATASection(string3.trim()));
        element2.appendChild(element5);
        Element element6 = document.createElement("query");
        element2.appendChild(element6);
        Element element7 = document.createElement("sql");
        element7.appendChild(document.createCDATASection(string4.trim()));
        element6.appendChild(element7);
        element.appendChild(element2);
    }

    public static Document getDocument() {
        return document;
    }
}

