/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.common.utils.UtilResources;
import oracle.dbtools.logging.Timer;
import oracle.dbtools.raptor.utils.ProvideTnsnamesDir;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.WindowsUtility;

public class TNSHelper {
    public static final String ENV_OH = "ORACLE_HOME";
    public static final String ENV_TA = "TNS_ADMIN";
    public static final String ENV_LA = "LDAP_ADMIN";
    private static Map<String, Long> lastModified = new HashMap<String, Long>();
    private static Object LOCK = new Object();
    private static final String NETWORK_ADMIN_PATH = File.separator + "network" + File.separator + "admin";
    public static final String FILE_TNS = NETWORK_ADMIN_PATH + File.separator + "tnsnames.ora";
    private static ArrayList<TCPTNSEntry> s_entries = null;
    private static Logger logger = Logger.getLogger("oracle.dbtools.raptor.utils");
    private static FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.equalsIgnoreCase(".tnsnames") || string.toLowerCase().startsWith("tnsnames.");
        }
    };
    private static ProvideTnsnamesDir getProvideTnsnamesDir = null;

    public static void forceDirty() {
        lastModified = new HashMap<String, Long>();
    }

    private static boolean checkForTns(String string) {
        logger.info(UtilResources.getString("TNSHelper.12") + string);
        boolean bl = false;
        File file = new File(string);
        if (file.exists() && file.listFiles(filter).length > 0) {
            bl = true;
        }
        return bl;
    }

    private static File getTNSFileContent(boolean bl) throws IOException, NotDirtyException {
        boolean bl2;
        String string;
        File file;
        logger.finest("getTNSFileContent - START");
        String string2 = System.getenv().get(ENV_OH);
        String string3 = System.getenv().get(ENV_TA);
        String string4 = System.getProperty("jdbc.driver.home");
        String string5 = System.getProperty("user.home");
        String string6 = null;
        ProvideTnsnamesDir provideTnsnamesDir = TNSHelper.getProvideTnsnamesDir();
        if (provideTnsnamesDir != null && (file = provideTnsnamesDir.getTnsnamesDir()) != null) {
            try {
                string = file.getAbsolutePath();
                if (TNSHelper.checkForTns(string)) {
                    string6 = string;
                }
            }
            catch (Throwable throwable) {
                string6 = null;
            }
        }
        if (string6 == null && TNSHelper.checkForTns(string5)) {
            string6 = string5;
        }
        if (!(bl2 = PlatformUtils.isWindows()) && string6 == null && TNSHelper.checkForTns("/etc")) {
            string6 = "/etc";
        }
        if (string3 != null && string6 == null && TNSHelper.checkForTns(string3)) {
            string6 = string3;
        }
        string = NETWORK_ADMIN_PATH;
        if (string4 != null && string6 == null && TNSHelper.checkForTns(string4 + string)) {
            string6 = string4 + string;
        }
        if (string2 != null && string6 == null && TNSHelper.checkForTns(string2 + string)) {
            string6 = string2 + string;
        }
        if (string6 == null && bl2) {
            string2 = null;
            String string7 = null;
            logger.info(UtilResources.getString("TNSHelper.20"));
            String string8 = "SOFTWARE\\ORACLE";
            try {
                List<String> list = WindowsUtility.readStringSubKeys(-2147483646, string8);
                String string9 = null;
                for (String string10 : list) {
                    String string11 = string8 + "\\" + string10;
                    string9 = WindowsUtility.readString(-2147483646, string11, "ORACLE_HOME_KEY");
                    if (string9 == null) continue;
                    logger.info(UtilResources.getString("TNSHelper.24") + string9);
                    string7 = WindowsUtility.readString(-2147483646, string11, ENV_TA);
                    logger.info(UtilResources.getString("TNSHelper.26") + string7);
                    break;
                }
                if (string9 != null) {
                    string2 = WindowsUtility.readString(-2147483646, string9, ENV_OH);
                    logger.info(UtilResources.getString("TNSHelper.29") + string2);
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            if (string2 != null && string7 == null) {
                string6 = string2 + string;
            }
            if (string6 == null && string7 != null) {
                string6 = string7;
            }
        }
        if (string6 == null) {
            return null;
        }
        if (!TNSHelper.isDirty(string6)) {
            throw new NotDirtyException();
        }
        s_entries = new ArrayList();
        logger.finest("getTNSFileContent - END");
        return new File(string6);
    }

    public static String getOracleHome() {
        String string = System.getenv().get(ENV_OH);
        if (string == null && PlatformUtils.isWindows()) {
            String string2 = "SOFTWARE\\ORACLE";
            try {
                List<String> list = WindowsUtility.readStringSubKeys(-2147483646, string2);
                String string3 = null;
                if (list != null && !list.isEmpty()) {
                    for (String string4 : list) {
                        String string5 = string2 + "\\" + string4;
                        string3 = WindowsUtility.readString(-2147483646, string5, "ORACLE_HOME_KEY");
                        logger.info(UtilResources.getString("TNSHelper.24") + string3);
                    }
                    if (string3 != null) {
                        string = WindowsUtility.readString(-2147483646, string3, ENV_OH);
                        logger.info(UtilResources.getString("TNSHelper.29") + string);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    public static boolean isDirty(String string) {
        boolean bl = false;
        File file = new File(string);
        for (File file2 : file.listFiles(filter)) {
            if (lastModified.get(file2.toString()) != null && lastModified.get(file2.toString()).longValue() == file2.lastModified()) continue;
            bl = true;
        }
        return bl;
    }

    public static void updateTimeStamps(String string) {
        File file = new File(string);
        for (File file2 : file.listFiles(filter)) {
            lastModified.put(file2.toString(), new Long(file2.lastModified()));
        }
    }

    public static TCPTNSEntry getEntry(String string) {
        ArrayList<TCPTNSEntry> arrayList = TNSHelper.getTNSEntries();
        for (TCPTNSEntry tCPTNSEntry : arrayList) {
            if (!tCPTNSEntry.getName().equalsIgnoreCase(string)) continue;
            return tCPTNSEntry;
        }
        return null;
    }

    private static ArrayList<TCPTNSEntry> getTNSEntries(File file) throws IOException {
        logger.finest("getTNSItems - START");
        ArrayList<TCPTNSEntry> arrayList = new ArrayList<TCPTNSEntry>();
        if (file != null && file.exists() && file.isDirectory()) {
            for (File file2 : file.listFiles(filter)) {
                arrayList.addAll(TNSHelper.getTNSEntries(file2));
            }
            TNSHelper.updateTimeStamps(file.toString());
        } else if (file != null && file.exists()) {
            List<TCPTNSEntry> list = TNSHelper.parseTnsFile(file);
            TNSHelper.updateTimeStamps(file.getParent());
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static List<TCPTNSEntry> parseTnsFile(File file) throws FileNotFoundException, IOException {
        ArrayList<TCPTNSEntry> arrayList = new ArrayList<TCPTNSEntry>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        logger.finest("getTNSItems - OPEN: " + file.getPath());
        int n = 0;
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        TCPTNSEntry tCPTNSEntry = null;
        String string2 = null;
        String string3 = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.indexOf("#") > 0) {
                string = string.substring(0, string.indexOf("#"));
            }
            if (string.indexOf(35) == 0) continue;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '(') {
                    ++n;
                    continue;
                }
                if (string.charAt(i) != ')') continue;
                --n;
            }
            stringBuilder.append(string);
            if (stringBuilder.indexOf("=") <= 0) continue;
            String string4 = stringBuilder.substring(0, stringBuilder.indexOf("=")).trim();
            int n2 = 0;
            for (int i = 0; i < string4.length(); ++i) {
                if (string4.charAt(i) == '(') {
                    ++n2;
                    continue;
                }
                if (string4.charAt(i) != ')') continue;
                --n2;
            }
            if (n != n2) continue;
            try {
                string2 = stringBuilder.substring(0, stringBuilder.indexOf("=")).trim();
                string3 = stringBuilder.substring(stringBuilder.indexOf("=") + 1).trim();
                if (string2.trim().toLowerCase().equals("ifile")) {
                    try {
                        String string5 = file.getParent() + File.separator;
                        Object object = new File(string5 + string3);
                        if (!((File)object).exists()) {
                            object = new File(string3);
                        }
                        if (((File)object).exists()) {
                            arrayList.addAll(TNSHelper.getTNSEntries((File)object));
                        } else {
                            logger.severe(UtilResources.getString("TNSHelper.38") + string3);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    stringBuilder.setLength(0);
                    continue;
                }
                if (string2.length() <= 0 || string3.trim().length() <= 0) continue;
                TCPTNSEntry tCPTNSEntry2 = null;
                for (TCPTNSEntry tCPTNSEntry3 : arrayList) {
                    if (!tCPTNSEntry3.getName().equalsIgnoreCase(string3)) continue;
                    tCPTNSEntry2 = tCPTNSEntry3;
                }
                tCPTNSEntry = tCPTNSEntry2 != null ? new TCPTNSEntry(string2, tCPTNSEntry2.getDescriptor()) : new TCPTNSEntry(string2, string3);
                arrayList.add(tCPTNSEntry);
                stringBuilder.setLength(0);
                logger.fine(UtilResources.getString("TNSHelper.39") + string2);
                n = 0;
            }
            catch (Exception exception) {}
        }
        logger.finest("getTNSItems - CLOSE: " + file.getPath());
        bufferedReader.close();
        logger.finest("getTNSItems - END");
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<TCPTNSEntry> getTNSEntries() {
        Object object = LOCK;
        synchronized (object) {
            Object object2;
            logger.finest("getTNSEntries - START");
            Timer timer = new Timer();
            timer.start();
            if (s_entries == null) {
                s_entries = new ArrayList();
            }
            ArrayList<TCPTNSEntry> arrayList = s_entries;
            try {
                object2 = TNSHelper.getTNSFileContent(false);
                if (object2 != null) {
                    logger.info(UtilResources.getString("TNSHelper.43") + ((File)object2).toString());
                    arrayList = TNSHelper.getTNSEntries((File)object2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = new Comparator<TCPTNSEntry>(){

                @Override
                public int compare(TCPTNSEntry tCPTNSEntry, TCPTNSEntry tCPTNSEntry2) {
                    return Collator.getInstance().compare(tCPTNSEntry.toString(), tCPTNSEntry2.toString());
                }
            };
            Collections.sort(arrayList, object2);
            logger.finest("Finished Parsing TNS in" + timer.durationInSecs());
            logger.finest("getTNSEntries - END");
            if (s_entries != arrayList) {
                s_entries.addAll(arrayList);
            }
            return arrayList;
        }
    }

    public static ProvideTnsnamesDir getProvideTnsnamesDir() {
        return getProvideTnsnamesDir;
    }

    public static void setProvideTnsnamesDir(ProvideTnsnamesDir provideTnsnamesDir) {
        getProvideTnsnamesDir = provideTnsnamesDir;
    }

    public static void main(String[] stringArray) throws Exception {
        logger.info("OH=" + System.getenv(ENV_OH));
        logger.info("TA=" + System.getenv(ENV_TA));
        ArrayList<TCPTNSEntry> arrayList = TNSHelper.getTNSEntries();
        for (TCPTNSEntry tCPTNSEntry : arrayList) {
            logger.info(tCPTNSEntry.toString());
        }
        System.exit(0);
    }

    private static class NotDirtyException
    extends Exception {
        private NotDirtyException() {
        }
    }
}

