/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader in;
    private String encoding = System.getProperty("file.encoding");
    private byte[] slack;
    private int begin;

    public ReaderInputStream(Reader reader) {
        this.in = reader;
    }

    public ReaderInputStream(Reader reader, String string) {
        this(reader);
        if (string == null) {
            throw new IllegalArgumentException("encoding must not be null");
        }
        this.encoding = string;
    }

    @Override
    public synchronized int read() throws IOException {
        int n;
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        if (this.slack != null && this.begin < this.slack.length) {
            n = this.slack[this.begin];
            if (++this.begin == this.slack.length) {
                this.slack = null;
            }
        } else {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) <= 0) {
                n = -1;
            }
            n = byArray[0];
        }
        if (n < -1) {
            n = (byte)(n + 256);
        }
        return n;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        while (this.slack == null) {
            char[] cArray = new char[n2];
            int n3 = this.in.read(cArray);
            if (n3 == -1) {
                return -1;
            }
            if (n3 <= 0) continue;
            this.slack = new String(cArray, 0, n3).getBytes(this.encoding);
            this.begin = 0;
        }
        if (n2 > this.slack.length - this.begin) {
            n2 = this.slack.length - this.begin;
        }
        System.arraycopy(this.slack, this.begin, byArray, n, n2);
        if ((this.begin += n2) >= this.slack.length) {
            this.slack = null;
        }
        return n2;
    }

    @Override
    public synchronized void mark(int n) {
        try {
            this.in.mark(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        if (this.slack != null) {
            return this.slack.length - this.begin;
        }
        if (this.in.ready()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        this.slack = null;
        this.in.reset();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.slack = null;
            this.in = null;
        }
    }
}

