/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.io.Serializable;
import oracle.dbtools.raptor.query.QueryParameter;

public class Column
extends QueryParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String onClickClass;
    private String format;
    private String align;
    private String vAlign;
    private String id;
    private String cellRenderer;
    private String cellEditor;
    private String cellPopup;
    private ClassLoader classLoader;
    private Boolean editable;
    private Boolean hidden;

    public Column() {
    }

    public Column(String string, String string2, String string3, String string4) {
        this.setName(string);
        if (string2 != null) {
            this.setAlign(string2);
        }
        if (string3 != null) {
            this.setVAlign(string3);
        }
        if (string4 != null) {
            this.format = string4;
        }
    }

    public void setOnClickClass(String string) {
        this.onClickClass = string;
    }

    public String getOnClickClass() {
        return this.onClickClass;
    }

    public void setAlign(String string) {
        this.align = string;
    }

    public String getAlign() {
        return this.align;
    }

    public void setVAlign(String string) {
        this.vAlign = string;
    }

    public String getVAlign() {
        return this.vAlign;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setID(String string) {
        this.id = string;
    }

    public String getID() {
        return this.id;
    }

    @Override
    public String toXML(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Column.getIndent(n) + "<column");
        if (this.format != null) {
            stringBuilder.append(" colFormat=\"" + this.format + "\"");
        }
        if (this.align != null) {
            stringBuilder.append(" align=\"" + this.align + "\"");
        }
        if (this.vAlign != null) {
            stringBuilder.append(" valign=\"" + this.vAlign + "\"");
        }
        if (this.hidden != null) {
            stringBuilder.append(" hidden=\"" + this.hidden.toString() + "\"");
        }
        if (this.editable != null) {
            stringBuilder.append(" isEditable=\"" + this.editable.toString() + "\"");
        }
        if (this.cellRenderer != null) {
            stringBuilder.append(" cellRenderer=\"" + this.cellRenderer + "\"");
        }
        if (this.cellEditor != null) {
            stringBuilder.append(" cellEditor=\"" + this.cellEditor + "\"");
        }
        if (this.cellPopup != null) {
            stringBuilder.append(" cellPopup=\"" + this.cellPopup + "\"");
        }
        stringBuilder.append(this.getBaseAttributes());
        stringBuilder.append(">\n");
        stringBuilder.append(Column.getIndent(n + 1) + "<colName><![CDATA[" + this.getName() + "]]></colName>\n");
        stringBuilder.append(this.getBaseChildren(n + 1));
        stringBuilder.append(Column.getIndent(n) + "</column>\n");
        return stringBuilder.toString();
    }

    public void setCellRenderer(String string) {
        this.cellRenderer = string;
    }

    public String getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellEditor(String string) {
        this.cellEditor = string;
    }

    public String getCellEditor() {
        return this.cellEditor;
    }

    public void setCellPopup(String string) {
        this.cellPopup = string;
    }

    public String getCellPopup() {
        return this.cellPopup;
    }

    public void setEditable(boolean bl) {
        this.editable = new Boolean(bl);
    }

    public Boolean isEditable() {
        return this.editable != null && this.editable != false;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public boolean isHidden() {
        if (this.hidden == null) {
            return false;
        }
        return this.hidden;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

