/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraTemporalDatumFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMPTZ;

public class OraTIMESTAMPTZFormat
extends OraTemporalDatumFormat {
    private static final int REGIONIDBIT = 128;
    private static final byte OFFSET_HOUR = 20;
    private static final byte OFFSET_MINUTE = 60;
    private static final String[] digit = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    public OraTIMESTAMPTZFormat(String string, OraLocaleInfo oraLocaleInfo) throws ParseException {
        super(string, oraLocaleInfo, null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraTIMESTAMPTZFormat && super.equals(object);
    }

    public String format(TIMESTAMPTZ tIMESTAMPTZ) {
        return this.format(tIMESTAMPTZ, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(TIMESTAMPTZ tIMESTAMPTZ, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = this.formatTemporalDatum(OraTIMESTAMPTZ.getInstance(tIMESTAMPTZ), stringBuffer, fieldPosition);
        int n = stringBuffer2.indexOf("GMT");
        if (n >= 0 && stringBuffer2.length() - n >= 9 && (stringBuffer2.charAt(n + 3) == '+' || stringBuffer2.charAt(n + 3) == '-') && stringBuffer2.charAt(n + 4) >= '0' && stringBuffer2.charAt(n + 4) <= '9' && stringBuffer2.charAt(n + 5) >= '0' && stringBuffer2.charAt(n + 5) <= '9' && stringBuffer2.charAt(n + 6) == ':' && stringBuffer2.charAt(n + 7) >= '0' && stringBuffer2.charAt(n + 7) <= '9' && stringBuffer2.charAt(n + 8) >= '0' && stringBuffer2.charAt(n + 8) <= '9') {
            stringBuffer2.delete(n, n + 3);
        }
        return stringBuffer2;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object == null || object instanceof TIMESTAMPTZ) {
            return this.format((TIMESTAMPTZ)object, stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException(Messages.getString("OraTIMESTAMPTZFormat.70"));
    }

    public TIMESTAMPTZ parse(String string, ParsePosition parsePosition) {
        OraTIMESTAMPTZ oraTIMESTAMPTZ = (OraTIMESTAMPTZ)this.parseTemporalDatum(string, parsePosition, UTC, true);
        return oraTIMESTAMPTZ != null ? oraTIMESTAMPTZ.getDatum() : null;
    }

    @Override
    protected OraTemporalDatum getTemporalDatum(Calendar calendar, int n) {
        return OraTIMESTAMPTZ.getInstance(calendar, n);
    }
}

