/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMP;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraTemporalDatumFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMP;

public class OraTIMESTAMPFormat
extends OraTemporalDatumFormat {
    public OraTIMESTAMPFormat(String string, OraLocaleInfo oraLocaleInfo) throws ParseException {
        this(string, oraLocaleInfo, null);
    }

    public OraTIMESTAMPFormat(String string, OraLocaleInfo oraLocaleInfo, TimeZone timeZone) throws ParseException {
        super(string, oraLocaleInfo, timeZone);
    }

    @Override
    public void applyPattern(String string) throws ParseException {
        String string2 = string.toUpperCase(Locale.US);
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        n = -1;
        while ((n = string2.indexOf("TZ", n + 1)) >= 0 && n <= string2.length() - 3) {
            char c = string2.charAt(n + 2);
            if (c != 'R' && c != 'D' && c != 'H' && c != 'M') continue;
            int n2 = -1;
            int n3 = 0;
            while ((n2 = string2.indexOf(34, n2 + 1)) < n && n2 != -1) {
                ++n3;
            }
            if (n3 % 2 != 0) continue;
            throw new ParseException(Messages.getString("OraTIMESTAMPFormat.11"), n);
        }
        super.applyPattern(stringBuffer.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraTIMESTAMPFormat && super.equals(object);
    }

    public String format(TIMESTAMP tIMESTAMP) {
        return this.format(tIMESTAMP, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(TIMESTAMP tIMESTAMP, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.formatTemporalDatum(OraTIMESTAMP.getInstance(tIMESTAMP), stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object == null || object instanceof TIMESTAMP) {
            return this.format((TIMESTAMP)object, stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException(Messages.getString("OraTIMESTAMPFormat.51"));
    }

    public TIMESTAMP parse(String string, ParsePosition parsePosition) {
        OraTIMESTAMP oraTIMESTAMP = (OraTIMESTAMP)this.parseTemporalDatum(string, parsePosition, UTC);
        return oraTIMESTAMP != null ? oraTIMESTAMP.getDatum() : null;
    }

    @Override
    protected OraTemporalDatum getTemporalDatum(Calendar calendar, int n) {
        OraTIMESTAMP oraTIMESTAMP = OraTIMESTAMP.getInstance(calendar, n);
        oraTIMESTAMP.setSessionTimeZone(this.getSessionTimeZone());
        return oraTIMESTAMP;
    }
}

