/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.INLSSupplier;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.jdbc.OracleConnection;

public class NLSProvider {
    private static final Map<Object, DefaultNLSProvider> providers = new HashMap<Object, DefaultNLSProvider>();
    private static INLSSupplier _supplier;

    public static void setNLSSupplier(INLSSupplier iNLSSupplier) {
        _supplier = iNLSSupplier;
    }

    public static DefaultNLSProvider getProvider(String string) {
        if (_supplier != null && _supplier.getNLSProvider(string) != null) {
            return NLSProvider.getProvider(_supplier.getNLSProvider(string).getConnection());
        }
        return null;
    }

    public static DefaultNLSProvider getProvider(Connection connection) {
        DefaultNLSProvider defaultNLSProvider = providers.get(connection);
        if (defaultNLSProvider == null) {
            block5: {
                try {
                    if (_supplier != null) {
                        defaultNLSProvider = _supplier.getNLSProvider(connection);
                    }
                }
                catch (Exception exception) {
                    if (connection == null) break block5;
                    Logger.getLogger(DefaultNLSProvider.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            if (defaultNLSProvider == null) {
                defaultNLSProvider = connection instanceof OracleConnection ? new OracleNLSProvider(connection) : new DefaultNLSProvider(connection);
            }
            providers.put(connection, defaultNLSProvider);
        }
        return defaultNLSProvider;
    }
}

