/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowTrimout
implements IShowCommand {
    private static final String[] SHOWTRIMOUT = new String[]{"trim", "trimo", "trimou", "trimout"};

    @Override
    public String[] getShowAliases() {
        return SHOWTRIMOUT;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowTrimout(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowTrimout(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty("script.runner.settrimout");
        if (bl != null && bl.equals(Boolean.TRUE)) {
            scriptRunnerContext.write("trimout ON\n");
        } else {
            scriptRunnerContext.write("trimout OFF\n");
        }
        return true;
    }
}

