/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.regex.PatternSyntaxException;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowSqlcode
implements IShowCommand {
    private static final String[] SHOWSQLCODE = new String[]{"sqlcode"};

    @Override
    public String[] getShowAliases() {
        return SHOWSQLCODE;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowSqlcode(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowSqlcode(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)scriptRunnerContext.getProperty("sqldev.last.err.message.forsqlcode");
        int n = 0;
        if (string != null) {
            try {
                String string2 = string.split("\n")[0].trim();
                n = string2.matches("^[^\\-]*\\-[0-9]+.*$") ? Integer.parseInt(string2.replaceAll("^[^\\-]*\\-([0-9]+).*$", "$1")) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                n = -1;
            }
        }
        scriptRunnerContext.write("sqlcode " + n + "\n");
        return true;
    }
}

