/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IEndOfShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowSpparameter
implements IShowCommand,
IEndOfShowCommand {
    private static final String[] SHOWSPPARAMETER = new String[]{"spparameter", "spparameters"};

    @Override
    public String[] getShowAliases() {
        return SHOWSPPARAMETER;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowSpparameters(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doShowSpparameters(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        block30: {
            String string = ScriptUtils.eatOneWord(iSQLCommand.getSql()).trim().toLowerCase();
            String string2 = null;
            string2 = string.startsWith(SHOWSPPARAMETER[1]) ? string.replaceAll("^" + SHOWSPPARAMETER[1], "").trim().split("\\s+")[0] : string.replaceAll("^" + SHOWSPPARAMETER[0], "").trim().split("\\s+")[0];
            String string3 = "%";
            if (!string2.equals("")) {
                string3 = "%" + string2 + "%";
            }
            boolean bl = false;
            boolean bl2 = false;
            ResultSet resultSet = null;
            ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
            Connection connection2 = scriptRunnerContext.getCurrentConnection();
            try {
                if (connection2 != null) {
                    bl = connectionResolver.lock(connection2);
                }
                if (!bl) break block30;
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", null);
                String string4 = "SELECT  substr(SID,0,20) SID,  substr(NAME,0,50) NAME,  TYPE,  DISPLAY_VALUE VALUE FROM V$SPPARAMETER  WHERE UPPER(NAME) LIKE UPPER(:NMBIND_SHOW_OBJ)  ORDER BY NAME,VALUE";
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string3);
                resultSet = DBUtil.getInstance(scriptRunnerContext.getCurrentConnection()).executeQuery(string4, arrayList);
                if (resultSet != null) {
                    Integer n;
                    ResultSetFormatter resultSetFormatter;
                    block31: {
                        resultSetFormatter = new ResultSetFormatter(scriptRunnerContext);
                        resultSetFormatter.setProgressUpdater(scriptRunnerContext.getTaskProgressUpdater());
                        n = null;
                        try {
                            if (scriptRunnerContext.getProperty("script.runner.arraysize") != null) {
                                n = Integer.valueOf((String)scriptRunnerContext.getProperty("script.runner.arraysize"));
                                break block31;
                            }
                            boolean bl3 = false;
                            Connection connection3 = scriptRunnerContext.getBaseConnection();
                            if (connection3 != null) {
                                bl3 = connectionResolver.lock(connection3);
                            }
                            if (!bl3) break block31;
                            try {
                                Properties properties = connectionResolver.getConnectionInfo(connectionResolver.getConnectionName(connection3));
                                n = Integer.valueOf(properties.getProperty("PreferfedFetchSize"));
                            }
                            finally {
                                connectionResolver.unlock(connection3);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (n != null) {
                        try {
                            resultSet.setFetchSize(n);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    resultSetFormatter.rset2sqlplusShrinkToSize(resultSet, scriptRunnerContext.getCurrentConnection(), scriptRunnerContext.getOutputStream());
                    break block30;
                }
                scriptRunnerContext.write(Messages.getString("SHOWSPPARAMETERSNORESULTSET"));
            }
            catch (IOException iOException) {
                scriptRunnerContext.write(iOException.getLocalizedMessage());
            }
            catch (SQLException sQLException) {
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", sQLException.getMessage());
                scriptRunnerContext.write(sQLException.getLocalizedMessage());
            }
            finally {
                if (resultSet != null) {
                    DBUtil.closeResultSet(resultSet);
                }
                if (bl) {
                    try {
                        connectionResolver.unlock(connection2);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return true;
    }
}

