/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowRelease
implements IShowCommand {
    private static final String[] SHOWRELEASE = new String[]{"rel", "rele", "relea", "releas", "release"};

    @Override
    public String[] getShowAliases() {
        return SHOWRELEASE;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowRelease(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    public boolean doShowRelease(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = DBUtil.getInstance(scriptRunnerContext.getCurrentConnection()).executeOracleReturnOneCol("select * from v$version where banner like '%Oracle%'", null);
        if (string != null) {
            String[] stringArray = string.split(" ");
            String string2 = "[0-9]*\\.[0-9]*\\.[0-9]*\\.[0-9]*\\.[0-9]*";
            String string3 = null;
            try {
                for (String string4 : stringArray) {
                    if (!Pattern.matches(string2, string4)) continue;
                    string3 = string4;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                scriptRunnerContext.write(patternSyntaxException.getLocalizedMessage() + "\n");
            }
            if (string3 != null) {
                String[] stringArray2 = string3.split("\\.");
                try {
                    int n = new Integer(stringArray2[0]) * 100000000;
                    n += new Integer(stringArray2[1]) * 1000000;
                    n += new Integer(stringArray2[2]) * 10000;
                    n += new Integer(stringArray2[3]) * 100;
                    scriptRunnerContext.write(Messages.getString("SHOWRELEASE") + " " + (n += new Integer(stringArray2[4]).intValue()) + "\n");
                }
                catch (NumberFormatException numberFormatException) {
                    scriptRunnerContext.write(numberFormatException.getLocalizedMessage() + "\n");
                }
            }
        }
        return true;
    }
}

