/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.jdbc.OracleConnection;

public class ShowNls
implements IShowCommand,
IShowPrefixNameNewline {
    private static final String[] SHOWNLS = new String[]{"nls"};

    @Override
    public String[] getShowAliases() {
        return SHOWNLS;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowNls(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowNls(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (DBUtil.isOracleConnectionAlive(connection)) {
                List<List<?>> list = DBUtil.getInstance(connection).executeReturnListofList("select name, value, upper(name) namesort from (select parameter name,value from nls_session_parameters union all SELECT 'DB_TIMEZONE' name, DBTIMEZONE  value FROM DUAL union all SELECT 'SESSION_TIMEZONE' name, SESSIONTIMEZONE value FROM DUAL union all SELECT 'SESSION_TIMEZONE_OFFSET' name, TZ_OFFSET(SESSIONTIMEZONE) value from DUAL union all SELECT parameter name, value FROM nls_database_parameters WHERE parameter='NLS_CHARACTERSET') viewname order by namesort", null);
                boolean bl = true;
                for (List<?> list2 : list) {
                    if (!bl) {
                        scriptRunnerContext.write(list2.get(0).toString() + " " + list2.get(1).toString() + "\n");
                    }
                    bl = false;
                }
            } else {
                scriptRunnerContext.write("No Live Oracle Connection.\n");
            }
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }
}

