/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.jdbc.OracleConnection;

public class ShowInstance
extends CommandListener
implements IShowCommand,
IShowPrefixNameNewline {
    String sql = "select     s.username username,     i.instance_name instance_name,     i.host_name host_name,     to_char(s.sid) sid,     (select substr(banner, instr(banner, 'Release ')+8,10) from v$version where rownum = 1) version,    to_char(startup_time, 'YYYYMMDD') startup_day from     v$session s,    v$instance i,    v$process p where     s.paddr = p.addr and     sid = (select sid from v$mystat where rownum = 1)";

    @Override
    public String[] getShowAliases() {
        return new String[]{"instance"};
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Object object;
        try {
            object = connection.getMetaData().getUserName();
            if ("SYS".equalsIgnoreCase((String)object) || "SYSTEM".equalsIgnoreCase((String)object)) {
                scriptRunnerContext.write("Instance \"local\"" + Show.m_lineSeparator);
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = DBUtil.getInstance(connection);
        List<List<?>> list = ((DBUtil)object).executeReturnListofList(this.sql, null);
        try {
            if (connection instanceof OracleConnection) {
                if (list != null && list.size() == 2) {
                    for (int i = 0; i < list.get(0).size(); ++i) {
                        scriptRunnerContext.write(list.get(0).get(i).toString() + " " + list.get(1).get(i).toString() + "\n");
                    }
                }
            } else {
                scriptRunnerContext.write("Instance \"local\"" + Show.m_lineSeparator);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return false;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

