/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowAutoprint
implements IShowCommand {
    private static final String[] SHOWAUTOPRINT = new String[]{"autop", "autopr", "autopri", "autoprin", "autoprint"};

    @Override
    public String[] getShowAliases() {
        return SHOWAUTOPRINT;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowAutoprint(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowAutoprint(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty("script.runner.context.autoprint");
        if (bl != null && bl.equals(Boolean.TRUE)) {
            scriptRunnerContext.write("autoprint ON\n");
        } else {
            scriptRunnerContext.write("autoprint OFF\n");
        }
        return true;
    }
}

