/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.bridge;

public class CopyToOracleHint {
    private String _query = null;
    private String _queryWithoutHint = null;
    private boolean _hasCopyToOracleHint = false;
    private String _catalog = null;
    private String _schema = null;
    private String _table = null;
    public static final String COPYTOORACLEHINT = "/*CTO:";

    public CopyToOracleHint(String string) {
        this._query = string;
        if (string != null) {
            if (this._query.indexOf(COPYTOORACLEHINT) != -1) {
                this._hasCopyToOracleHint = true;
            }
            if (this._hasCopyToOracleHint) {
                this._queryWithoutHint = this.removeCopyToOracleHint(this._query);
                this.processHint(this._query);
            } else {
                this._queryWithoutHint = this._query;
            }
        }
    }

    private void processHint(String string) {
        if (string != null) {
            int n = string.indexOf(COPYTOORACLEHINT);
            int n2 = string.indexOf("*/", n);
            if (n != -1 && n2 != -1) {
                String string2 = string.substring(n, n2);
                String[] stringArray = string2.split(":");
                this._catalog = stringArray[1];
                this._schema = stringArray[2];
                this._table = stringArray[3];
            }
        }
    }

    public boolean isCopyToOracle() {
        return this._hasCopyToOracleHint;
    }

    public String getCatalog() {
        return this._catalog;
    }

    public String getSchema() {
        return this._schema;
    }

    public String getTable() {
        return this._table;
    }

    private String removeCopyToOracleHint(String string) {
        if (string != null) {
            int n = string.indexOf(COPYTOORACLEHINT);
            int n2 = string.indexOf("*/", n);
            if (n != -1 && n2 != -1) {
                string = string.substring(n2 + 2);
            }
        }
        return string;
    }

    public static String createCopyToOracleHint(String string, String string2, String string3) {
        return COPYTOORACLEHINT + string + ":" + string2 + ":" + string3 + "*/";
    }

    public String queryWithoutHint() {
        return this._queryWithoutHint;
    }

    public String getFullName() {
        if (this.getCatalog() != null && this.getSchema() != null) {
            return this.getCatalog() + "." + this.getSchema() + "." + this.getTable();
        }
        if (this.getCatalog() != null && this.getSchema() == null) {
            return this.getCatalog() + ".." + this.getTable();
        }
        if (this.getCatalog() == null && this.getSchema() != null) {
            return this.getSchema() + "." + this.getTable();
        }
        return this.getTable();
    }
}

