/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.query.Bind;

public class AliasCommand
extends CommandListener
implements IHelp {
    private static String LIST = "list";
    private static String DROP = "drop";
    private static String ALIAS = "alias";
    private static String SAVE = "save";
    private static String LOAD = "load";
    private static String SHOW = "show";

    @Override
    public String getCommand() {
        return "ALIAS";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String[] stringArray = iSQLCommand.getSql().trim().split("[ \t\n]+");
        if (stringArray.length > 0) {
            String string = null;
            if (stringArray[0].toLowerCase().equals(this.getCommandName())) {
                if (stringArray.length == 1) {
                    ArrayList<String> arrayList = Aliases.getInstance().getAliases();
                    Iterator<String> iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        scriptRunnerContext.write(iterator.next() + "\n");
                    }
                    return this.handleReturn(true);
                }
                if (stringArray.length > 1) {
                    String string2 = "";
                    if (iSQLCommand.getSql().contains("=") && !stringArray[1].startsWith("=")) {
                        String string3;
                        String[] stringArray2 = iSQLCommand.getSql().trim().split("=")[0].split("\\s+");
                        string2 = stringArray2[1];
                        if (stringArray2.length > 2) {
                            string2 = string2 + stringArray2[2];
                        }
                        if ((string3 = iSQLCommand.getSql().substring(iSQLCommand.getSql().toLowerCase().indexOf("=") + 1).trim()).startsWith(":")) {
                            if (string3.length() > 1) {
                                string3 = string3.substring(1);
                                Bind bind = scriptRunnerContext.getVarMap().get(string3.toUpperCase());
                                if (bind != null) {
                                    string = bind.getValue();
                                }
                            }
                            if (string == null || string.equals("")) {
                                scriptRunnerContext.write("ALIAS-006: No valid bind value\n");
                                return this.handleReturn(true);
                            }
                        } else {
                            String string4 = string3.toUpperCase();
                            if (string3.length() > 5 && string4.startsWith("Q'") && string3.endsWith(ScriptParser.getEndQuoteString(string3.substring(2, 3)) + "'")) {
                                string3 = string3.substring(3, string3.length() - 2);
                            } else if (string3 == null || string3.equals("")) {
                                scriptRunnerContext.write("ALIAS-005: String not valid\n");
                                return this.handleReturn(true);
                            }
                            string = string3;
                        }
                        Aliases.getInstance().add(string2, string);
                        return this.handleReturn(true);
                    }
                    if (stringArray[1].toLowerCase().equals(DROP)) {
                        if (stringArray.length == 3) {
                            Aliases.getInstance().drop(stringArray[2]);
                            return this.handleReturn(true);
                        }
                        scriptRunnerContext.write("ALIAS-011 -  alias drop failed \n");
                        return true;
                    }
                    if (stringArray[1].toLowerCase().equals(LIST)) {
                        String string5 = "";
                        ArrayList<String> arrayList = Aliases.getInstance().getAliases();
                        if (stringArray.length > 2 && stringArray[2].length() > 0) {
                            string5 = stringArray[2];
                            if (arrayList.contains(string5)) {
                                String string6 = new String(new char[string5.length()]).replace("\u0000", "-");
                                scriptRunnerContext.write(MessageFormat.format("{0}\n{1}\n", string5, string6));
                                scriptRunnerContext.write(Aliases.getInstance().get(string5).getQuery() + "\n");
                            } else {
                                scriptRunnerContext.write(MessageFormat.format("ALIAS-010 - alias {0} not found \n", string5));
                            }
                        } else {
                            Iterator<String> iterator = arrayList.iterator();
                            while (iterator.hasNext()) {
                                scriptRunnerContext.write(iterator.next() + "\n");
                            }
                        }
                        return this.handleReturn(true);
                    }
                    if (stringArray[1].toLowerCase().equals(SAVE)) {
                        if (scriptRunnerContext.getProperty("script.runner.jline") != null) {
                            if (stringArray.length > 2 && stringArray[2] != null) {
                                scriptRunnerContext.write(Aliases.getInstance().save(stringArray[2]));
                            } else {
                                scriptRunnerContext.write(Aliases.getInstance().save());
                            }
                        } else {
                            scriptRunnerContext.write("ALIAS-008 - save only enabled in command line mode\n");
                        }
                        return this.handleReturn(true);
                    }
                    if (stringArray[1].toLowerCase().equals(LOAD)) {
                        if (scriptRunnerContext.getProperty("script.runner.jline") != null) {
                            if (stringArray.length > 2 && stringArray[2] != null) {
                                scriptRunnerContext.write(Aliases.getInstance().load(stringArray[2]));
                            } else {
                                scriptRunnerContext.write(Aliases.getInstance().load());
                            }
                        } else {
                            scriptRunnerContext.write("ALIAS-009 - load only enabled in command line mode\n");
                        }
                        return this.handleReturn(true);
                    }
                    scriptRunnerContext.write("ALIAS-001: Alias command not found\n");
                    return this.handleReturn(true);
                }
                scriptRunnerContext.write("ALIAS-002: Alias add not enough arguments\n");
                scriptRunnerContext.write(this.getHelp());
                return this.handleReturn(true);
            }
        }
        return false;
    }

    public String getCommandName() {
        return ALIAS;
    }

    boolean handleReturn(boolean bl) {
        if (!bl) {
            // empty if block
        }
        return true;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }
}

