/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetPause
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_PAUSE;
    private static final Boolean ON = Boolean.TRUE;
    private static final Boolean OFF = Boolean.FALSE;
    private static final String startUnique = "\nNewPagemarker";
    private static final String endUnique = "Z\n";
    private int pageNo = 0;
    private Integer pauseUnique = null;

    public SetPause() {
        super(s_cmdStmtSubType);
    }

    @Override
    public boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getSQLOrig().split("\\s+")[1].toLowerCase().equals("pau") || iSQLCommand.getSQLOrig().split("\\s+")[1].toLowerCase().equals("pause")) {
            String string = (String)iSQLCommand.getProperty("prop_file_string");
            if (string == null || string.equals("")) {
                scriptRunnerContext.write(Messages.getString("SETPAUSENOARG"));
            } else if (string.equalsIgnoreCase("on")) {
                scriptRunnerContext.putProperty("script.runner.set_pause", ON);
            } else if (string.equalsIgnoreCase("off")) {
                scriptRunnerContext.putProperty("script.runner.set_pause", OFF);
            } else {
                if (string.length() > 1 && (string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\""))) {
                    string = string.substring(1, string.length() - 1);
                }
                scriptRunnerContext.putProperty("script.runner.set_pause_value", string);
            }
            return true;
        }
        scriptRunnerContext.write(MessageFormat.format("SP2-0158: unknown SET option \"{0}\"\n", iSQLCommand.getSQLOrig().split("\\s+")[1]));
        return false;
    }

    @Override
    protected void doEndCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        super.doEndCmd(connection, scriptRunnerContext, iSQLCommand);
        Boolean bl = (Boolean)scriptRunnerContext.getProperty("script.runner.set_pause");
        if (bl != null) {
            if (bl.equals(ON)) {
                this.setCmdOn(true);
            } else if (bl.equals(OFF)) {
                this.setCmdOn(false);
            }
        }
    }

    private int matchesInString(ScriptRunnerContext scriptRunnerContext, StringBuffer stringBuffer, int n) {
        String string = startUnique + n + endUnique;
        int n2 = 0;
        int n3 = 0;
        while ((n2 = stringBuffer.indexOf(string, n2)) != -1) {
            ++n2;
            ++n3;
        }
        return n3;
    }

    private int rewrite(ScriptRunnerContext scriptRunnerContext, StringBuffer stringBuffer, int n, int n2) {
        String string = startUnique + n + endUnique;
        String string2 = startUnique + n2 + endUnique;
        int n3 = string2.length() - string.length();
        int n4 = 0;
        int n5 = 0;
        while ((n4 = stringBuffer.indexOf(string, n4)) != -1) {
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
            stringBuffer.setLength(n4);
            stringBuffer.append(string2);
            if (n4 + string.length() < stringBuffer2.length()) {
                stringBuffer.append(stringBuffer2.substring(n4 + string.length()));
            }
            ++n4;
            n4 += n3;
            if (++n5 < this.pageNo - 1) continue;
            break;
        }
        return n5;
    }

    public void mark(ScriptRunnerContext scriptRunnerContext, Object object, StringBuffer stringBuffer) {
        Integer n;
        ++this.pageNo;
        if (!(object instanceof BufferedOutputStream)) {
            return;
        }
        if (scriptRunnerContext.getProperty("script.runner.set_pause") != null && ((Boolean)scriptRunnerContext.getProperty("script.runner.set_pause")).equals(Boolean.TRUE)) {
            boolean bl;
            Integer n2;
            n = n2 = this.pauseUnique;
            if (n2 == null) {
                n = 1;
            }
            do {
                int n3;
                if ((n3 = this.matchesInString(scriptRunnerContext, stringBuffer, n)) == this.pageNo - 1) {
                    if (n2 == null) {
                        this.pauseUnique = n;
                    }
                    if (n == n2) {
                        // empty if block
                    }
                    break;
                }
                bl = false;
                do {
                    Integer n4 = n;
                    Integer n5 = n = Integer.valueOf(n + 1);
                } while ((n3 = this.matchesInString(scriptRunnerContext, stringBuffer, n)) != 0);
                if (n2 != null) {
                    this.rewrite(scriptRunnerContext, stringBuffer, n2, n);
                }
                this.pauseUnique = n;
            } while (!(bl = true));
        } else {
            return;
        }
        stringBuffer.append(startUnique + n + endUnique);
    }

    public boolean writeOut(ScriptRunnerContext scriptRunnerContext, Object object, StringBuffer stringBuffer) throws IOException {
        if (!(object instanceof BufferedOutputStream)) {
            return false;
        }
        if (scriptRunnerContext.getProperty("script.runner.set_pause") != null && ((Boolean)scriptRunnerContext.getProperty("script.runner.set_pause")).equals(Boolean.TRUE) && scriptRunnerContext.getProperty("script.runner.set_pause_value") != null && this.pageNo != 0) {
            String string = startUnique + this.pauseUnique + endUnique;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            while ((n = stringBuffer.indexOf(string, n2)) != -1) {
                this.write(object, stringBuffer.substring(n2, n));
                ((BufferedOutputStream)object).flush();
                scriptRunnerContext.getHandleSetPauseProvider().handlePause(scriptRunnerContext, null);
                if (n + string.length() >= stringBuffer.length()) break;
                n2 = n += string.length();
                if (++n3 < this.pageNo) continue;
                bl = true;
                break;
            }
            if (n == -1 || bl) {
                this.write(object, stringBuffer.substring(n2));
            }
            this.pageNo = 0;
        } else {
            this.write(object, stringBuffer.toString());
        }
        return true;
    }

    public static void directWriteOut(ScriptRunnerContext scriptRunnerContext, OutputStreamWriter outputStreamWriter) {
        if (scriptRunnerContext != null && scriptRunnerContext.getProperty("script.runner.set_pause") != null && ((Boolean)scriptRunnerContext.getProperty("script.runner.set_pause")).equals(Boolean.TRUE) && scriptRunnerContext.getProperty("script.runner.set_pause_value") != null) {
            try {
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                Logger.getLogger("SetPause").log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            scriptRunnerContext.getHandleSetPauseProvider().handlePause(scriptRunnerContext, null);
        }
    }

    private void write(Object object, String string) throws IOException {
        try {
            ((BufferedOutputStream)object).write(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }
}

