/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetNet
extends AForAllStmtsCommand
implements IShowCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_NET;

    public SetNet() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getProperty("prop_file_string") != null) {
            String string = iSQLCommand.getSql();
            if ((string = string.trim().replaceAll("^[sS][eE][tT]\\s+[nN][eE][tT]\\s+", "").trim()).startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
                string = string.substring(1, string.length() - 1);
            } else if (string.startsWith("'") && string.endsWith("'") && string.length() > 1) {
                string = string.substring(1, string.length() - 1);
            }
            if (string.equalsIgnoreCase("ON")) {
                string = "ON";
            } else if (string.equalsIgnoreCase("OFF")) {
                string = "OFF";
            } else if (string.equalsIgnoreCase("READONLY")) {
                string = "READONLY";
            } else {
                scriptRunnerContext.write("ERROR:set net on|off|readonly\n");
                return true;
            }
            scriptRunnerContext.putProperty("script.runner.setnet", string);
        }
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"net"};
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)scriptRunnerContext.getProperty("script.runner.setnet");
        if (string == null) {
            string = "ON";
        }
        scriptRunnerContext.write("net: " + string + "\n");
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

