/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class Prompt
extends CommandListener {
    static ArrayList<IPromptListener> listeners = new ArrayList();

    public Prompt() {
        Prompt.addListener(DefaultPromptListener.getInstance());
    }

    public static void addListener(IPromptListener iPromptListener) {
        if (!listeners.contains(iPromptListener)) {
            listeners.add(iPromptListener);
        }
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return true;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        for (IPromptListener iPromptListener : listeners) {
            iPromptListener.consume(connection, scriptRunnerContext, iSQLCommand);
        }
    }

    private static class DefaultPromptListener
    implements IPromptListener {
        static DefaultPromptListener _instance = null;

        private DefaultPromptListener() {
        }

        public static IPromptListener getInstance() {
            if (_instance == null) {
                _instance = new DefaultPromptListener();
            }
            return _instance;
        }

        @Override
        public void consume(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
            String string = this.getPromptMessage(iSQLCommand);
            scriptRunnerContext.write(string);
        }

        private String getPromptMessage(ISQLCommand iSQLCommand) {
            String string = iSQLCommand.getSql();
            string = string.trim();
            boolean bl = false;
            int n = 0;
            for (n = 0; n < string.length(); ++n) {
                if (!Character.isWhitespace(string.charAt(n))) continue;
                bl = true;
                break;
            }
            if (bl) {
                return string.substring(n).trim() + "\n";
            }
            return "\n";
        }
    }

    public static interface IPromptListener {
        public void consume(Connection var1, ScriptRunnerContext var2, ISQLCommand var3);
    }
}

