/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;

public class OerrCommand
extends AForAllStmtsCommand
implements IHelp {
    private static final String CMD = "oerr";
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_OERR;

    public OerrCommand() {
        super(s_cmdStmtSubType);
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getSql().trim().toLowerCase().startsWith(CMD)) {
            scriptRunnerContext.write("\n");
            try {
                Oerr oerr = new Oerr();
                String string = iSQLCommand.getSql().substring(CMD.length());
                if (string.length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    if (stringTokenizer.countTokens() > 2) {
                        throw new OerrException(Messages.getString("OerrCommand.1"));
                    }
                    if (stringTokenizer.countTokens() == 1) {
                        scriptRunnerContext.write(oerr.oerr(string));
                    } else {
                        scriptRunnerContext.write(oerr.oerr(stringTokenizer.nextToken(), stringTokenizer.nextToken()));
                    }
                } else {
                    scriptRunnerContext.write(this.getHelp());
                }
            }
            catch (OerrException oerrException) {
                scriptRunnerContext.write(oerrException.getLocalizedMessage());
            }
            scriptRunnerContext.write("\n");
            return true;
        }
        return false;
    }

    @Override
    public String getCommand() {
        return CMD.toUpperCase();
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }
}

