/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.internal.Log;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import org.fusesource.jansi.Ansi;

public class Help
extends CommandListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (iSQLCommand.getSql() + " ").substring((iSQLCommand.getSql() + " ").indexOf(" ")).trim();
        try {
            String[] stringArray = string.split("\\s+");
            if (stringArray.length == 2 && stringArray[0].toLowerCase().equals("set")) {
                string = stringArray[0] + stringArray[1];
            }
            scriptRunnerContext.write(this.HelpOnOrIndex(string));
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return true;
    }

    private String HelpOnOrIndex(String string) throws Exception {
        if (string == null || string.equals("") || string.equalsIgnoreCase("help") || string.equalsIgnoreCase("index") || string.equalsIgnoreCase("?")) {
            return this.getHelpProperties("");
        }
        Enumeration<String> enumeration = HelpMessages.getKeys();
        String string2 = "";
        string2 = string2 + this.getHelpProperties(string);
        return string2;
    }

    private String getHelpProperties(String string) throws Exception {
        String string2 = null;
        Enumeration<String> enumeration = HelpMessages.getKeys();
        if (enumeration == null) {
            throw new Exception(Messages.getString("NO_HELP_KEYS"));
        }
        ArrayList<String> arrayList = Collections.list(enumeration);
        this.removeSetDetails(arrayList);
        for (IHelp object2 : CommandRegistry.getCommandsWithHelp()) {
            if (!object2.isSqlPlus()) {
                arrayList.add(object2.getCommand() + "*");
                continue;
            }
            arrayList.add(object2.getCommand());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(new LinkedHashSet<String>(arrayList));
        Collections.sort(arrayList2);
        if (string.equals("")) {
            string2 = Messages.getString("LIST_OF_HELP_TOPICS");
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = string3.replace("_", " ");
                if (string4.endsWith("*")) {
                    string4 = Ansi.ansi().bold().fg(Ansi.Color.WHITE).format(string4.replace("*", ""), new Object[0]).reset().toString();
                }
                stringBuilder.append("    ").append(string4).append("\n");
            }
            string2 = string2 + stringBuilder.toString();
        } else if (string.length() > 0 && !arrayList.contains(string) && !string.startsWith("set")) {
            string2 = Messages.getString("LIST_OF_HELP_TOPICS");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string5 : arrayList) {
                String string6 = string5.replace("_", " ");
                if (string6.toUpperCase().equals(string.trim().toUpperCase()) || string6.toUpperCase().equals(string.trim().toUpperCase() + "*")) {
                    IHelp iHelp;
                    string2 = HelpMessages.getString(string.replace(" ", "_").toUpperCase());
                    if (string2 == null) {
                        string2 = HelpMessages.getString(string.replace(" ", "_").toUpperCase() + "*");
                    }
                    if (string2 == null && (iHelp = CommandRegistry.getCommandWithHelp(string)) != null) {
                        string2 = iHelp.getHelp();
                    }
                    return string2;
                }
                if (!string6.toUpperCase().startsWith(string.toUpperCase())) continue;
                stringBuilder.append("    ").append(string6).append("\n");
            }
            string2 = string2 + stringBuilder.toString();
        } else {
            IHelp iHelp;
            string2 = HelpMessages.getString(string.replace(" ", "_").toUpperCase());
            if (string2 == null) {
                string2 = HelpMessages.getString(string.replace(" ", "_").toUpperCase() + "*");
            }
            if (string2 == null && (iHelp = CommandRegistry.getCommandWithHelp(string)) != null) {
                string2 = iHelp.getHelp();
            }
        }
        return string2;
    }

    private void removeSetDetails(ArrayList<String> arrayList) {
        Iterator<String> iterator = arrayList.iterator();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.toLowerCase().startsWith("set")) continue;
            arrayList2.add(string);
        }
        arrayList2.add("SET");
        arrayList.clear();
        for (String string : arrayList2) {
            arrayList.add(string);
        }
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public String printColumns(Collection<? extends CharSequence> collection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        int n = 80;
        int n2 = 0;
        for (CharSequence object : collection) {
            n2 = Math.max(n2, object.length());
        }
        Log.debug((Object[])new Object[]{"Max width: ", n2 += 3});
        StringBuilder stringBuilder2 = new StringBuilder();
        for (CharSequence charSequence : collection) {
            String string = charSequence.toString();
            if (string.endsWith("*")) {
                string = Ansi.ansi().bold().fg(Ansi.Color.WHITE).format(string.replace("*", ""), new Object[0]).reset().toString();
            }
            if (stringBuilder2.length() + n2 > n) {
                stringBuilder.append(stringBuilder2.toString() + "\n");
                stringBuilder2.setLength(0);
            }
            stringBuilder2.append(string);
            for (int i = 0; i < n2 - charSequence.length(); ++i) {
                stringBuilder2.append(' ');
            }
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }
}

