/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;

public class ChangeScriptRunnerContextCmd
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_COMMENT_SQL;
    public static final String SQLDEVSRC = "SQLDEV:SRC:";
    public static final String SQLERROR = "sqlError";

    public ChangeScriptRunnerContextCmd() {
        super(s_cmdStmtSubType);
    }

    @Override
    public void doBeginWatcher(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (this.isScriptCmd(connection, scriptRunnerContext, iSQLCommand)) {
            String[] stringArray;
            String string = null;
            if (iSQLCommand.getStmtClass() == SQLCommand.StmtType.G_C_MULTILINECOMMENT) {
                string = iSQLCommand.getSql().trim().substring(2, iSQLCommand.getSql().trim().length() - 2);
            } else if (iSQLCommand.getStmtClass() == SQLCommand.StmtType.G_C_COMMENT) {
                string = iSQLCommand.getSql().trim().substring(2);
            }
            string = string.substring(SQLDEVSRC.length()).trim();
            for (String string2 : stringArray = string.split(",")) {
                String[] stringArray2 = string2.split("=");
                if (!stringArray2[0].equalsIgnoreCase(SQLERROR)) continue;
                int n = Integer.parseInt(stringArray2[1]);
                scriptRunnerContext.setSqlError(n);
            }
            return true;
        }
        return false;
    }

    public boolean isScriptCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getStmtClass() == SQLCommand.StmtType.G_C_MULTILINECOMMENT) {
            String string = iSQLCommand.getSql().trim().substring(2, iSQLCommand.getSql().trim().length() - 2);
            return this.isSQLDevSRC(string);
        }
        if (iSQLCommand.getStmtClass() == SQLCommand.StmtType.G_C_COMMENT) {
            String string = iSQLCommand.getSql().trim().substring(2);
            return this.isSQLDevSRC(string);
        }
        return false;
    }

    private boolean isSQLDevSRC(String string) {
        return string.startsWith(SQLDEVSRC);
    }
}

