/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.logging.LogPaneHandler;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class ChangeLoggerLevel
extends CommandListener {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String[] stringArray = iSQLCommand.getSQLOrig().split("\\s+");
        Logger logger = null;
        if (stringArray.length == 3) {
            String string = Messages.getString("ChangeLoggerLevel.1");
            Object[] objectArray = new Object[]{stringArray[1], stringArray[2]};
            this.logger.info(MessageFormat.format(string, objectArray));
            logger = Logger.getLogger(stringArray[1]);
            logger.setLevel(Level.parse(stringArray[2]));
        } else if (stringArray.length == 2) {
            this.logger.info(MessageFormat.format(Messages.getString("ChangeLoggerLevel.2"), stringArray[1]));
            logger = Logger.getLogger("");
            logger.setLevel(Level.parse(stringArray[1]));
        }
        if (logger != null) {
            boolean bl = true;
            for (Handler handler : logger.getHandlers()) {
                if (!(handler instanceof LogPaneHandler)) continue;
                bl = false;
            }
            if (bl) {
                logger.addHandler(LogPaneHandler.getInstance());
            }
        }
        return true;
    }
}

