/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.BridgeParser;
import oracle.dbtools.raptor.newscriptrunner.commands.BridgeTableDef;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;

public class BridgeCmd
extends CommandListener
implements IHelp {
    BridgeParser _bridgeParser = null;
    boolean statusOK = true;

    @Override
    public String getCommand() {
        return "BRIDGE";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext != null && scriptRunnerContext.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(scriptRunnerContext.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        try {
            String string = iSQLCommand.getModifiedSQL();
            this._bridgeParser = new BridgeParser(string);
            for (BridgeTableDef bridgeTableDef : this._bridgeParser.getTableDefs()) {
                bridgeTableDef.setDefaultConn(connection);
                bridgeTableDef.setScriptRunnerContext(scriptRunnerContext);
                this.statusOK = bridgeTableDef.execute();
                if (this.statusOK) continue;
                break;
            }
            if (this._bridgeParser.getQuery() == null) {
                iSQLCommand.setSql("SELECT 1 FROM DUAL");
            }
        }
        catch (Exception exception) {
            scriptRunnerContext.write(this.getHelp());
            this.statusOK = false;
        }
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (!this.statusOK || scriptRunnerContext != null && scriptRunnerContext.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(scriptRunnerContext.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        String string = "";
        boolean bl = false;
        for (BridgeTableDef bridgeTableDef : this._bridgeParser.getTableDefs()) {
            String string2;
            String string3 = bridgeTableDef.getReport();
            if (string3 != null && !string3.equals("")) {
                scriptRunnerContext.write(string3);
            }
            if ((string2 = bridgeTableDef.getError()) == null || string2.equals("")) continue;
            scriptRunnerContext.write(string2);
            string = string + string2;
            bl = true;
        }
        if (bl) {
            scriptRunnerContext.putProperty("sqldev.error", Boolean.TRUE);
            scriptRunnerContext.putProperty("sqldev.last.err.message", string);
        }
        if (this._bridgeParser.getQuery() != null) {
            for (BridgeTableDef bridgeTableDef : this._bridgeParser.getTableDefs()) {
                if (bridgeTableDef._isReplace) continue;
                bridgeTableDef.drop();
            }
        }
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext != null && scriptRunnerContext.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(scriptRunnerContext.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return false;
        }
        if (this.statusOK) {
            if (this._bridgeParser.getQuery() != null) {
                iSQLCommand.setSql(this._bridgeParser.getQuery());
                return false;
            }
            return true;
        }
        return true;
    }

    private String JDBCToOracle(String string) {
        return string;
    }
}

