/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.jdbc.OracleResultSet;

public class ResultSetFormatterWrapper
extends ResultsFormatterWrapper {
    private ResultSet m_rs;
    private ResultSetMetaData m_meta;
    private String m_sql;
    private int[] m_dataTypes;
    private ArrayList<Integer> m_exportCols = null;

    protected ResultSetFormatterWrapper() {
    }

    public ResultSetFormatterWrapper(ResultSet resultSet) {
        this.setResultSet(resultSet);
    }

    public ResultSetFormatterWrapper(ResultSet resultSet, ArrayList<Integer> arrayList, List<String> list, int[] nArray, int[] nArray2, String string) {
        this.m_rs = resultSet;
        this.m_sql = string;
        this.m_exportCols = arrayList;
        this.setColumnNames(list);
        this.setColumnSizes(nArray);
        this.setPrecisions(nArray);
        this.m_dataTypes = nArray2;
    }

    public ResultSetFormatterWrapper(ResultSet resultSet, ArrayList<Integer> arrayList, String string) {
        this.m_sql = string;
        this.m_exportCols = arrayList;
        this.setResultSet(resultSet);
    }

    public ResultSetFormatterWrapper(ResultSet resultSet, ArrayList<Integer> arrayList) {
        this.m_exportCols = arrayList;
        this.setResultSet(resultSet);
    }

    protected void setResultSet(ResultSet resultSet) {
        this.m_rs = resultSet;
        String string = "";
        try {
            this.m_meta = ((PreparedStatement)this.m_rs.getStatement()).getMetaData();
            int[] nArray = this.m_exportCols == null ? new int[this.m_meta.getColumnCount() + 1] : new int[this.m_exportCols.size() + 1];
            int[] nArray2 = this.m_exportCols == null ? new int[this.m_meta.getColumnCount() + 1] : new int[this.m_exportCols.size() + 1];
            int[] nArray3 = this.m_exportCols == null ? new int[this.m_meta.getColumnCount() + 1] : new int[this.m_exportCols.size() + 1];
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            n = this.m_exportCols == null ? this.m_meta.getColumnCount() : this.m_exportCols.size();
            for (int i = 0; i < n; ++i) {
                if (this.m_exportCols == null) {
                    string = this.m_meta.getColumnName(i + 1);
                    arrayList.add(string);
                    switch (this.m_meta.getColumnType(i + 1)) {
                        case 91: 
                        case 92: 
                        case 93: {
                            nArray[i] = 25;
                            break;
                        }
                        default: {
                            nArray[i] = string.length();
                        }
                    }
                    nArray3[i] = this.m_meta.getScale(i + 1);
                    nArray2[i] = this.m_meta.getPrecision(i + 1);
                    continue;
                }
                string = this.m_meta.getColumnName(this.m_exportCols.get(i) + 1);
                arrayList.add(string);
                switch (this.m_meta.getColumnType(this.m_exportCols.get(i) + 1)) {
                    case 91: 
                    case 92: 
                    case 93: {
                        nArray[i] = 25;
                        break;
                    }
                    default: {
                        nArray[i] = string.length();
                    }
                }
                nArray3[i] = this.m_meta.getScale(this.m_exportCols.get(i) + 1);
                nArray2[i] = this.m_meta.getPrecision(this.m_exportCols.get(i) + 1);
            }
            this.setColumnNames(arrayList);
            this.setColumnSizes(nArray);
            this.setScales(nArray3);
            this.setPrecisions(nArray2);
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
    }

    @Override
    public Connection getConnection() {
        Connection connection = null;
        try {
            connection = this.m_rs.getStatement().getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return connection;
    }

    @Override
    public int getDataType(int n) throws SQLException {
        if (this.m_exportCols == null) {
            return this.m_meta.getColumnType(n + 1);
        }
        if (this.m_dataTypes == null) {
            return this.m_meta.getColumnType(this.m_exportCols.get(n) + 1);
        }
        return this.m_dataTypes[n];
    }

    @Override
    public int print() throws IOException {
        int n = 0;
        try {
            n = this.print(null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public String getSQL() {
        return this.m_sql;
    }

    @Override
    public int print(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws IOException, ExecutionException {
        int n = 0;
        this.m_formatter.start();
        try {
            this.m_rowNum = 0L;
            while (this.m_rs != null && this.m_rs.next()) {
                int n2;
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                } else if (this.isInterrupted()) {
                    this.m_rs.getStatement().cancel();
                    break;
                }
                ++this.m_rowNum;
                this.m_formatter.log(Messages.getString("ResultSetFormatterWrapper.1") + this.m_rs.getRow());
                this.m_formatter.startRow();
                Object object = null;
                if (this.m_exportCols == null) {
                    for (n2 = 0; n2 < this.m_meta.getColumnCount(); ++n2) {
                        object = this.m_rs instanceof OracleResultSet ? ((OracleResultSet)this.m_rs).getOracleObject(n2 + 1) : this.m_rs.getObject(n2 + 1);
                        this.m_formatter.printColumn(object, n2, n2);
                    }
                } else {
                    for (n2 = 0; n2 < this.m_exportCols.size(); ++n2) {
                        object = this.m_rs instanceof OracleResultSet ? ((OracleResultSet)this.m_rs).getOracleObject(this.m_exportCols.get(n2) + 1) : this.m_rs.getObject(this.m_exportCols.get(n2) + 1);
                        this.m_formatter.printColumn(object, n2, n2);
                    }
                }
                this.m_formatter.endRow();
                n = this.m_rs.getRow();
            }
        }
        catch (ExecutionException executionException) {
            try {
                if (this.m_rs != null) {
                    this.m_rs.getStatement().cancel();
                }
            }
            catch (Exception exception) {
                ExceptionHandler.handleException(exception);
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException);
        }
        this.m_formatter.end();
        return n;
    }

    @Override
    public void close() {
        if (this.m_rs != null) {
            DBUtil.closeResultSet(this.m_rs);
        }
    }
}

