/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.raptor.format.ANSIConsoleFormatter;
import oracle.dbtools.raptor.format.CSVFormatter;
import oracle.dbtools.raptor.format.DelimitedFormatter;
import oracle.dbtools.raptor.format.FixedFormatter;
import oracle.dbtools.raptor.format.HTMLFormatter;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.InsertFormatter;
import oracle.dbtools.raptor.format.JSONFormatter;
import oracle.dbtools.raptor.format.LoaderFormatter;
import oracle.dbtools.raptor.format.TxtFormatter;
import oracle.dbtools.raptor.format.XMLFormatter;

public class FormatRegistry {
    private static Map<String, IResultFormatter> s_registry = new TreeMap<String, IResultFormatter>();
    private static String m_lineTerminator = System.getProperty("line.terminator");

    public static synchronized void registerFormater(IResultFormatter iResultFormatter) {
        s_registry.put(iResultFormatter.getType().toLowerCase(), iResultFormatter);
    }

    public static synchronized void unregisterFormater(IResultFormatter iResultFormatter) {
        s_registry.remove(iResultFormatter.getType().toLowerCase());
    }

    public static synchronized IResultFormatter getFormatter(String string) {
        if (s_registry.isEmpty()) {
            FormatRegistry.registerBasics();
        }
        return s_registry.get(string.toLowerCase());
    }

    public static synchronized List<String> getTypes() {
        if (s_registry.isEmpty()) {
            FormatRegistry.registerBasics();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = s_registry.keySet();
        for (String string : set) {
            if (s_registry.get(string).isInternalOnly()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static synchronized List<String> getAllTypes() {
        if (s_registry.isEmpty()) {
            FormatRegistry.registerBasics();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(s_registry.keySet());
        return arrayList;
    }

    public static void setLineTerminator(String string) {
        m_lineTerminator = string;
    }

    public static String getLineTerminator() {
        return m_lineTerminator;
    }

    public static void registerBasics() {
        if (s_registry.isEmpty()) {
            try {
                FormatRegistry.registerFormater(new TxtFormatter());
                FormatRegistry.registerFormater(new CSVFormatter());
                FormatRegistry.registerFormater(new DelimitedFormatter());
                FormatRegistry.registerFormater(new InsertFormatter());
                FormatRegistry.registerFormater(new FixedFormatter());
                FormatRegistry.registerFormater(new XMLFormatter());
                FormatRegistry.registerFormater(new HTMLFormatter());
                FormatRegistry.registerFormater(new LoaderFormatter());
                FormatRegistry.registerFormater(new ANSIConsoleFormatter());
                FormatRegistry.registerFormater(new JSONFormatter());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

