/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;

public class DelimitedFormatter
extends ResultsFormatter {
    public static final String TYPE = "Delimited";
    public static final String EXT = "dsv";
    public static final String DEFAULT_DELIMITER = ",";
    public static final String KEY_HEADER = "EXPORT_DLM_HEADER";
    public static final String KEY_DELIMITER = "EXPORT_DLM_DELIMITER";
    public static final String KEY_REC_TERM = "EXPORT_DLM_REC_TERM";
    public static final String KEY_ENCLOSURES = "EXPORT_DLM_ENCLOSURES";
    public static final String KEY_ENCL_LEFT = "EXPORT_DLM_ENCL_LEFT";
    public static final String KEY_ENCL_RIGHT = "EXPORT_DLM_ENCL_RIGHT";
    public static final String KEY_ENCL_RIGHT_DOUBLE = "EXPORT_DLM_ENCL_RIGHT_DOUBLE";
    private static String s_delim = ",";
    private boolean _isHeader;

    public DelimitedFormatter() {
        super(TYPE, Messages.getString("FixedFormatter.4"), EXT);
    }

    public DelimitedFormatter(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    @Override
    public void start() throws IOException {
        String string;
        if (this._delimiter == null) {
            this._delimiter = s_delim;
        }
        String string2 = this._isEnclosed ? this._enclosureLeft : "";
        String string3 = string = this._isEnclosed ? this._enclosureRight : "";
        if (this.isHeader()) {
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String string4 = this.getColumnName(i);
                if (i < n - 1) {
                    this.write(string2 + string4 + string + this._delimiter);
                    continue;
                }
                this.write(string2 + string4 + string);
            }
            this.write(this.getLineTerminator());
        }
    }

    @Override
    public void startRow() throws IOException {
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        Object object2;
        String string = "";
        String string2 = this._enclosureLeft;
        String string3 = this._enclosureRight;
        String string4 = this._delimiter == null ? s_delim : this._delimiter;
        int n3 = this.getDataType(n);
        boolean bl = false;
        if (n3 == 1 && this._isEnclosed || n3 == -16 || n3 == -1 || n3 == -15 || n3 == -9 || n3 == 12 || n3 == 2005) {
            if (this._isEnclosureRightDoubled) {
                bl = true;
            }
        } else {
            string2 = "";
            string3 = "";
        }
        if ((object2 = this.getValue(object)) != null) {
            if (object != null) {
                String string5 = bl ? this.enclosureRightDouble(object2.toString()) : object2.toString();
                string = string4 + string2 + string5 + string3;
            } else {
                string2 = "";
                string3 = "";
                string = string4 + object2.toString();
            }
        } else {
            string = string4 + string2 + string3;
        }
        if (n == 0) {
            this.write(string2 + (string2.trim().length() > 0 ? string.substring(string4.length() + 1) : string.substring(string4.length())));
        } else {
            this.write(string);
        }
    }

    @Override
    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    @Override
    public void end() throws IOException {
    }

    @Override
    public void setTableName(String string) {
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public boolean isHeaderOptionSupported() {
        return true;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterConfigurable() {
        return true;
    }

    @Override
    public boolean isEnclosuresSupported() {
        return true;
    }

    @Override
    public void isHeader(boolean bl) {
        this._isHeader = bl;
    }

    @Override
    public boolean isHeader() {
        return this._isHeader;
    }

    @Override
    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    public String getDelimiterConfigKey() {
        return KEY_DELIMITER;
    }

    @Override
    public String getEnclosuresConfigKey() {
        return KEY_ENCLOSURES;
    }

    @Override
    public String getEnclosureLeftConfigKey() {
        return KEY_ENCL_LEFT;
    }

    @Override
    public String getEnclosureRightConfigKey() {
        return KEY_ENCL_RIGHT;
    }

    @Override
    public String getEnclosureRightDoubleConfigKey() {
        return KEY_ENCL_RIGHT_DOUBLE;
    }

    @Override
    public String getLineTerminator() {
        if (this._EOLChars == null) {
            super.getLineTerminator();
        }
        return this._EOLChars;
    }
}

