/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.CallableBindingSplitMode;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.DataVariable;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.CallableBindingImpl;
import oracle.dbtools.raptor.datatypes.objects.PLSQLRecord;

public class CallableBindingRECORD<P extends DataBinding>
extends CallableBindingImpl<P>
implements CallableBindingSplitMode<P> {
    protected BindContext context;
    private CallableStatement stmt = null;
    private List<CallableBindingSplitMode<DataVariable>> subBindings;

    public CallableBindingRECORD(BindContext bindContext, P p) {
        super(p);
        this.context = bindContext;
    }

    @Override
    public void setByNameBindToken(String string) {
    }

    @Override
    public String getByNameBindToken() {
        return null;
    }

    @Override
    public void setByPositionBindToken(String string) {
    }

    @Override
    public String getByPositionBindToken() {
        return null;
    }

    @Override
    public BindingStyle getBindingStyle(BindingMode bindingMode) {
        return BindingStyle.CUSTOM;
    }

    @Override
    public String getBindToken(BindingMode bindingMode) {
        return null;
    }

    @Override
    public CallableStatement getCallableStatement() {
        return this.stmt;
    }

    @Override
    protected void setCallableStatement(CallableStatement callableStatement) {
        this.stmt = callableStatement;
    }

    @Override
    protected void customBind(DataValue dataValue) throws SQLException {
        List<DataValue> list = dataValue.getComponents();
        Iterator<DataValue> iterator = list.iterator();
        for (CallableBindingSplitMode<DataVariable> callableBindingSplitMode : this.subBindings) {
            callableBindingSplitMode.bind(this.stmt, iterator.next());
        }
    }

    @Override
    protected void customBindIN(DataValue dataValue) throws SQLException {
    }

    @Override
    protected void customBind() throws SQLException {
        for (CallableBindingSplitMode<DataVariable> callableBindingSplitMode : this.subBindings) {
            callableBindingSplitMode.bind(this.stmt);
        }
    }

    @Override
    protected void customBindOUT() throws SQLException {
    }

    @Override
    public void customReportBinding(StringBuilder stringBuilder, String string, DataValue dataValue) {
        List<DataValue> list = dataValue.getComponents();
        Iterator<DataValue> iterator = list.iterator();
        for (CallableBindingSplitMode<DataVariable> callableBindingSplitMode : this.subBindings) {
            callableBindingSplitMode.reportBinding(stringBuilder, string, iterator.next());
        }
    }

    @Override
    public PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder pLSQLBoundBlockBuilder) {
        this.subBindings = new LinkedList<CallableBindingSplitMode<DataVariable>>();
        String string = this.getParameter().getName() == null ? "\"<RETURN>\"" : this.getParameter().getName();
        DataType dataType = this.param.getDataType();
        List<NamedValue<DataType>> list = dataType.getTypeComponents();
        for (NamedValue<DataType> namedValue : list) {
            String string2 = string + "." + namedValue.getName();
            DataType dataType2 = namedValue.getValue();
            DataVariable dataVariable = dataType.getDataTypeFactory().getDataVariable(string2, dataType2, this.mode);
            CallableBinding<DataVariable> callableBinding = dataType2.getBind(this.context, dataVariable);
            CallableBindingSplitMode<DataVariable> callableBindingSplitMode = callableBinding.getSplitModeBinding();
            PLSQLBoundBlockBuilder pLSQLBoundBlockBuilder2 = callableBindingSplitMode.getBuilder();
            pLSQLBoundBlockBuilder.addBuilder(pLSQLBoundBlockBuilder2);
            this.subBindings.add(callableBindingSplitMode);
        }
        if (this.param instanceof DataParameter) {
            switch (this.mode) {
                case RETURN: {
                    pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PreCallWrapper, string + " := ");
                    break;
                }
                default: {
                    pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.ParamBinding, string + "=>" + string);
                }
            }
            pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.DataDecls, string + " " + dataType.getConstrainedDataTypeString() + ";");
        }
        return pLSQLBoundBlockBuilder;
    }

    @Override
    protected DataValue customOutput() throws SQLException {
        if (this.outputValue == null) {
            PLSQLRecord pLSQLRecord = new PLSQLRecord(this.getDataType());
            for (CallableBindingSplitMode<DataVariable> callableBindingSplitMode : this.subBindings) {
                DataValue dataValue = callableBindingSplitMode.getOutput();
                pLSQLRecord.add(dataValue.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DEFAULT));
            }
            this.outputValue = this.dataType.getDataValue(pLSQLRecord);
        }
        return this.outputValue;
    }

    @Override
    protected CallableBindingSplitMode<P> customSplitModeBinding() {
        return this;
    }
}

