/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Calendar;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.TimeZoneDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraTIMESTAMPLTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class TIMESTAMPLTZ
extends TimeZoneDatum {
    protected TIMESTAMPLTZ(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        Object object = dataValueInternal.getInternalValue();
        switch (stringType) {
            case GENERIC: {
                try {
                    if (object instanceof oracle.sql.TIMESTAMPLTZ) {
                        return new StringValue(((oracle.sql.TIMESTAMPLTZ)object).timestampValue(dataTypeConnectionProvider.getNLSConnection(), Calendar.getInstance()).toString());
                    }
                    break;
                }
                catch (SQLException sQLException) {
                    throw new DataTypeIllegalArgumentException(this, object);
                }
            }
        }
        return super.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        Object object2 = dataValueInternal.getInternalValue();
        switch (valueType) {
            case JDBC: {
                try {
                    if (object2 instanceof oracle.sql.TIMESTAMPLTZ) {
                        oracle.sql.TIMESTAMPLTZ tIMESTAMPLTZ = (oracle.sql.TIMESTAMPLTZ)object2;
                        return oracle.sql.TIMESTAMPLTZ.toTimestamp(dataTypeConnectionProvider.getNLSConnection(), (byte[])tIMESTAMPLTZ.getBytes());
                    }
                    break;
                }
                catch (SQLException sQLException) {
                    throw new DataTypeIllegalArgumentException(this, object2);
                }
            }
        }
        return super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                if (dataTypeConnectionProvider.peekNLSConnection() == null) {
                    return super.customTypedClass(dataTypeConnectionProvider, valueType);
                }
            }
            case DATUM: {
                return oracle.sql.TIMESTAMPLTZ.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -102;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        try {
            if (object instanceof oracle.sql.TIMESTAMPLTZ) {
                return object;
            }
            if (object instanceof byte[]) {
                return new oracle.sql.TIMESTAMPLTZ(Arrays.copyOf((byte[])object, ((byte[])object).length));
            }
            Object object2 = super.customInternalValue(dataTypeConnectionProvider, object);
            if (dataTypeConnectionProvider.peekNLSConnection() != null && object2 instanceof Timestamp) {
                return new oracle.sql.TIMESTAMPLTZ(dataTypeConnectionProvider.getNLSConnection(), (Timestamp)object2);
            }
            return this.typedValueFromNLSString(dataTypeConnectionProvider, object2.toString());
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object);
        }
    }

    protected oracle.sql.TIMESTAMPLTZ typedValueFromNLSString(DataTypeConnectionProvider dataTypeConnectionProvider, String string) {
        OraTIMESTAMPLTZFormat oraTIMESTAMPLTZFormat;
        try {
            oraTIMESTAMPLTZFormat = ((OracleNLSProvider)NLSProvider.getProvider(dataTypeConnectionProvider.getNLSConnection())).getOraTIMESTAMPLTZFormat();
        }
        catch (ParseException parseException) {
            oraTIMESTAMPLTZFormat = null;
        }
        return oraTIMESTAMPLTZFormat.parse(string, new ParsePosition(0));
    }

    @Override
    protected String customUnconstrainedDataTypeString() {
        return "TIMESTAMP_LTZ_UNCONSTRAINED";
    }

    @Override
    protected String customDataTypeString() {
        Integer n = this.typeMetadata.get_data_scale();
        if (n != null) {
            return "TIMESTAMP (" + n + ") WITH LOCAL TIME ZONE";
        }
        return "TIMESTAMP WITH LOCAL TIME ZONE";
    }
}

