/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.TemporalDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.sql.DATE;

public class TIMESTAMP
extends TemporalDatum {
    protected TIMESTAMP(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        Object object = dataValueInternal.getInternalValue();
        switch (stringType) {
            case GENERIC: {
                try {
                    return new StringValue(((oracle.sql.TIMESTAMP)object).timestampValue().toString());
                }
                catch (SQLException sQLException) {
                    throw new DataTypeIllegalArgumentException(this, object);
                }
            }
        }
        return super.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        Object object2 = dataValueInternal.getInternalValue();
        oracle.sql.TIMESTAMP tIMESTAMP = (oracle.sql.TIMESTAMP)object2;
        try {
            switch (valueType) {
                case JDBC: {
                    return tIMESTAMP.timestampValue();
                }
            }
            return super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object2);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return oracle.sql.TIMESTAMP.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 93;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        if (object instanceof oracle.sql.TIMESTAMP) {
            return object;
        }
        if (object instanceof DATE) {
            return new oracle.sql.TIMESTAMP((DATE)object);
        }
        if (object instanceof byte[]) {
            return new oracle.sql.TIMESTAMP(Arrays.copyOf((byte[])object, ((byte[])object).length));
        }
        Object object2 = super.customInternalValue(dataTypeConnectionProvider, object);
        if (object2 instanceof Timestamp) {
            return new oracle.sql.TIMESTAMP((Timestamp)object2);
        }
        return this.typedValueFromNLSString(dataTypeConnectionProvider, object2.toString());
    }

    protected oracle.sql.TIMESTAMP typedValueFromNLSString(DataTypeConnectionProvider dataTypeConnectionProvider, String string) {
        OraTIMESTAMPFormat oraTIMESTAMPFormat;
        try {
            oraTIMESTAMPFormat = ((OracleNLSProvider)NLSProvider.getProvider(dataTypeConnectionProvider.getNLSConnection())).getOraTIMESTAMPFormat();
        }
        catch (ParseException parseException) {
            oraTIMESTAMPFormat = null;
        }
        return oraTIMESTAMPFormat.parse(string, new ParsePosition(0));
    }

    @Override
    protected String customDataTypeString() {
        Integer n = this.typeMetadata.get_data_scale();
        if (n != null) {
            return "TIMESTAMP (" + n + ")";
        }
        return "TIMESTAMP";
    }

    @Override
    protected String customUnconstrainedDataTypeString() {
        return "TIMESTAMP_UNCONSTRAINED";
    }
}

