/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatumAtName;
import oracle.dbtools.raptor.datatypes.util.StringValue;

public abstract class Datum
extends DataTypeImpl {
    protected Datum(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        switch (stringType) {
            case GENERIC: {
                Object object = dataValueInternal.getInternalValue();
                if (object instanceof oracle.sql.Datum) {
                    try {
                        return new StringValue(((oracle.sql.Datum)object).stringValue());
                    }
                    catch (SQLException sQLException) {
                        throw new DataTypeSQLException(sQLException);
                    }
                }
                return super.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
            }
        }
        return super.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
    }

    @Override
    public <P extends DataBinding> CallableBinding<P> getBind(BindContext bindContext, P p) {
        return new CallableBindingDatumAtName<P>(bindContext, p);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        Object object2 = dataValueInternal.getInternalValue();
        try {
            switch (valueType) {
                case JAVA: {
                    return this.customTypedValue(dataTypeConnectionProvider, dataValueInternal, ValueType.JDBC, object);
                }
                case DATUM: {
                    Object object3 = super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
                    oracle.sql.Datum datum = (oracle.sql.Datum)object3;
                    return datum;
                }
                case JDBC: {
                    Object object4 = super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
                    if (object4 instanceof oracle.sql.Datum) {
                        oracle.sql.Datum datum = (oracle.sql.Datum)object4;
                        return datum.toJdbc();
                    }
                    return object4;
                }
            }
            return super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, object2, exception);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case JAVA: {
                return this.customTypedClass(dataTypeConnectionProvider, ValueType.JDBC);
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case JAVA: {
                return this.customSqlDataType(ValueType.JDBC);
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected boolean customRequiresConnection() {
        return false;
    }
}

