/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.sql.CHAR;

public abstract class CharacterDatum
extends Datum {
    protected CharacterDatum(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        Object object2 = dataValueInternal.getInternalValue();
        String string = (String)object2;
        try {
            switch (valueType) {
                case DATUM: {
                    return new CHAR(string, CHAR.DEFAULT_CHARSET);
                }
            }
            return super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object2);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return CHAR.class;
            }
            case DEFAULT: {
                return String.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 1;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        if (object instanceof String) {
            return object;
        }
        if (object instanceof CHAR) {
            CHAR cHAR = (CHAR)object;
            return cHAR.stringValue();
        }
        return String.valueOf(object);
    }

    @Override
    protected String customDataTypeString() {
        String string = this.getPlainDataTypeString();
        String string2 = this.typeMetadata.get_char_used();
        Integer n = this.typeMetadata.get_char_length();
        return this.buildConstraintedString(string, string2, n);
    }

    @Override
    protected String customConstrainedDataTypeString() {
        Integer n = this.typeMetadata.get_char_length();
        if (n == null || 0 == n) {
            return this.customUnconstrainedDataTypeString();
        }
        return super.customConstrainedDataTypeString();
    }

    @Override
    protected String customUnconstrainedDataTypeString() {
        String string = this.typeMetadata.get_char_used();
        return this.buildConstraintedString(this.getPlainDataTypeString(), string, 2000);
    }

    private String buildConstraintedString(String string, String string2, Integer n) {
        if (string != null && n != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (string2 != null && "B".equals(string2)) {
                stringBuffer.append("(").append(n).append(" BYTES").append(")");
            } else if (string2 != null && "C".equals(string2)) {
                stringBuffer.append("(").append(n).append(" CHARS").append(")");
            } else {
                stringBuffer.append("(").append(n).append(")");
            }
            return stringBuffer.toString();
        }
        return string;
    }
}

