/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshall.DataValueMarshallHandler;
import oracle.dbtools.raptor.datatypes.objects.ClobDatum;
import oracle.dbtools.raptor.datatypes.objects.LargeVarchar;
import oracle.dbtools.raptor.datatypes.oracle.sql.LOB;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import org.xml.sax.SAXException;

public class CLOB
extends LOB {
    protected CLOB(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        LargeVarchar largeVarchar = (LargeVarchar)dataValueInternal.getInternalValue();
        return largeVarchar.getStringValue(stringType, n);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        Object object2 = dataValueInternal.getInternalValue();
        ClobDatum clobDatum = (ClobDatum)object2;
        try {
            switch (valueType) {
                case JDBC: 
                case DATUM: 
                case TARGET: {
                    return clobDatum.getTypedValue(dataTypeConnectionProvider, valueType, object);
                }
            }
            return super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataTypeIllegalArgumentException(this, object2, illegalArgumentException);
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object2);
        }
        catch (IOException iOException) {
            throw new DataTypeIllegalArgumentException(this, object2);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case JAVA: {
                return Reader.class;
            }
            case JDBC: 
            case DATUM: {
                return Clob.class;
            }
            case DEFAULT: {
                return ClobDatum.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 2005;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        try {
            if (object == null) {
                return new ClobDatum();
            }
            if (object instanceof ClobDatum) {
                return object;
            }
            return ClobDatum.constructFrom(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataTypeIllegalArgumentException(this, object, illegalArgumentException);
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object, sQLException);
        }
        catch (IOException iOException) {
            throw new DataTypeIllegalArgumentException(this, object, iOException);
        }
    }

    @Override
    protected void customMarshallToXml(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, DataValueMarshallHandler dataValueMarshallHandler, String string) throws SAXException {
        ClobDatum clobDatum = (ClobDatum)dataValueInternal.getInternalValue();
        clobDatum.marshallToXml(this, dataValueMarshallHandler, string);
    }

    @Override
    public Object startDataValue(String string, boolean bl) {
        if (bl) {
            return null;
        }
        return ClobDatum.getBuilder();
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, char[] cArray, int n, int n2) {
        ClobDatum.ClobDatumBuilder clobDatumBuilder = (ClobDatum.ClobDatumBuilder)namedValue.getValue();
        try {
            clobDatumBuilder.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new DataTypeIOException(iOException);
        }
    }

    @Override
    public DataValue endDataValue(NamedValue namedValue) {
        ClobDatum.ClobDatumBuilder clobDatumBuilder = (ClobDatum.ClobDatumBuilder)namedValue.getValue();
        try {
            return this.getDataValue(clobDatumBuilder != null ? clobDatumBuilder.build() : null);
        }
        catch (IOException iOException) {
            throw new DataTypeIOException(iOException);
        }
    }
}

